/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModBlockProperties {
    public static final BooleanProperty EXTENDING = BooleanProperty.create((String)"extending");
    public static final BooleanProperty HAS_WATER = BooleanProperty.create((String)"has_water");
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");
    public static final BooleanProperty KNOT = BooleanProperty.create((String)"knot");
    public static final BooleanProperty TIPPED = BooleanProperty.create((String)"tipped");
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");
    public static final BooleanProperty AXIS_Y = BooleanProperty.create((String)"axis_y");
    public static final BooleanProperty AXIS_X = BooleanProperty.create((String)"axis_x");
    public static final BooleanProperty AXIS_Z = BooleanProperty.create((String)"axis_z");
    public static final BooleanProperty LAVALOGGED = BooleanProperty.create((String)"lavalogged");
    public static final BooleanProperty ANTIQUE = BooleanProperty.create((String)"ye_olde");
    public static final BooleanProperty TREASURE = BooleanProperty.create((String)"treasure");
    public static final BooleanProperty PACKED = BooleanProperty.create((String)"packed");
    public static final BooleanProperty GLOWING = BooleanProperty.create((String)"glowing");
    public static final BooleanProperty WATCHED = BooleanProperty.create((String)"watched");
    public static final BooleanProperty CULLED = BooleanProperty.create((String)"culled");
    public static final BooleanProperty HAS_BLOCK = BooleanProperty.create((String)"has_block");
    public static final BooleanProperty ROTATING = BooleanProperty.create((String)"rotating");
    public static final BooleanProperty ON_PRESSURE_PLATE = BooleanProperty.create((String)"on_pressure_plate");
    public static final BooleanProperty TWO_FACED = BooleanProperty.create((String)"two_faced");
    public static final BooleanProperty SLANTED = BooleanProperty.create((String)"slanted");
    public static final BooleanProperty FLIP_TILE = BooleanProperty.create((String)"flip_tile");
    public static final EnumProperty<Rotation> ROTATE_TILE = EnumProperty.create((String)"rotate_tile", Rotation.class);
    public static final IntegerProperty HOUR = IntegerProperty.create((String)"hour", (int)0, (int)23);
    public static final IntegerProperty LIGHT_LEVEL_0_15 = IntegerProperty.create((String)"light_level", (int)0, (int)15);
    public static final IntegerProperty LIGHT_LEVEL_5_15 = IntegerProperty.create((String)"light_level", (int)5, (int)15);
    public static final IntegerProperty LIGHT_LEVEL_0_7 = IntegerProperty.create((String)"light_level", (int)0, (int)7);
    public static final IntegerProperty WIND_STRENGTH = IntegerProperty.create((String)"wind_strength", (int)0, (int)4);
    public static final IntegerProperty PANCAKES_1_8 = IntegerProperty.create((String)"pancakes", (int)1, (int)8);
    public static final IntegerProperty ROTATION_4 = IntegerProperty.create((String)"rotation", (int)0, (int)4);
    public static final IntegerProperty BURNING = IntegerProperty.create((String)"burning", (int)0, (int)8);
    public static final IntegerProperty BOOKS = IntegerProperty.create((String)"books", (int)1, (int)4);
    public static final IntegerProperty FINITE_FLUID_LEVEL = IntegerProperty.create((String)"level", (int)1, (int)16);
    public static final IntegerProperty BALLS = IntegerProperty.create((String)"balls", (int)1, (int)4);
    public static final EnumProperty<Topping> TOPPING = EnumProperty.create((String)"topping", Topping.class);
    public static final EnumProperty<Winding> WINDING = EnumProperty.create((String)"winding", Winding.class);
    public static final EnumProperty<PostType> POST_TYPE = EnumProperty.create((String)"type", PostType.class);
    public static final EnumProperty<RakeDirection> RAKE_DIRECTION = EnumProperty.create((String)"shape", RakeDirection.class);
    public static final EnumProperty<DisplayStatus> ITEM_STATUS = EnumProperty.create((String)"item_status", DisplayStatus.class);
    public static final EnumProperty<Rune> RUNE = EnumProperty.create((String)"rune", Rune.class);
    public static final EnumProperty<Bunting> NORTH_BUNTING = EnumProperty.create((String)"north", Bunting.class);
    public static final EnumProperty<Bunting> SOUTH_BUNTING = EnumProperty.create((String)"south", Bunting.class);
    public static final EnumProperty<Bunting> WEST_BUNTING = EnumProperty.create((String)"west", Bunting.class);
    public static final EnumProperty<Bunting> EAST_BUNTING = EnumProperty.create((String)"east", Bunting.class);
    public static final ModelDataKey<BlockState> MIMIC = MimicBlockTile.MIMIC_KEY;
    public static final ModelDataKey<Boolean> FANCY = new ModelDataKey(Boolean.class);
    public static final ModelDataKey<Boolean> FRAMED = new ModelDataKey(Boolean.class);
    public static final ModelDataKey<Float> RENDER_OFFSET = new ModelDataKey(Float.class);
    public static final ModelDataKey<SignPostBlockTile.Sign> SIGN_UP = new ModelDataKey(SignPostBlockTile.Sign.class);
    public static final ModelDataKey<SignPostBlockTile.Sign> SIGN_DOWN = new ModelDataKey(SignPostBlockTile.Sign.class);
    public static final ModelDataKey<BlockState> FLOWER_0 = new ModelDataKey(BlockState.class);
    public static final ModelDataKey<BlockState> FLOWER_1 = new ModelDataKey(BlockState.class);
    public static final ModelDataKey<BlockState> FLOWER_2 = new ModelDataKey(BlockState.class);
    public static final ModelDataKey<ResourceKey<SoftFluid>> FLUID = new ModelDataKey(ResourceKey.class);
    public static final ModelDataKey<Integer> FLUID_COLOR = new ModelDataKey(Integer.class);
    public static final ModelDataKey<Float> FILL_LEVEL = new ModelDataKey(Float.class);
    public static final ModelDataKey<BlackboardData> BLACKBOARD = new ModelDataKey(BlackboardData.class);
    public static final ModelDataKey<BookPileBlockTile.BooksList> BOOKS_KEY = new ModelDataKey(BookPileBlockTile.BooksList.class);

    public static enum Topping implements StringRepresentable
    {
        NONE("none"),
        HONEY("honey"),
        SYRUP("syrup"),
        CHOCOLATE("chocolate"),
        JAM("jam");

        private final String name;

        private Topping(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        @NotNull
        public static Pair<Topping, Item> fromFluidItem(Item item) {
            Pair holder = SoftFluidStack.fromItem((ItemStack)item.getDefaultInstance());
            if (holder == null) {
                return Pair.of((Object)((Object)NONE), null);
            }
            SoftFluidStack s = (SoftFluidStack)holder.getFirst();
            FluidContainerList.Category cat = (FluidContainerList.Category)holder.getSecond();
            if (cat.isEmpty() || cat.getAmount() != 1) {
                return Pair.of((Object)((Object)NONE), null);
            }
            Topping t = Topping.fromFluid(s);
            if (t != NONE) {
                return Pair.of((Object)((Object)t), (Object)cat.getEmptyContainer());
            }
            return Pair.of((Object)((Object)NONE), null);
        }

        public static Topping fromFluid(SoftFluidStack stack) {
            if (stack.isEmpty()) {
                return NONE;
            }
            if (stack.is(MLBuiltinSoftFluids.HONEY)) {
                return HONEY;
            }
            String name = ((ResourceKey)stack.getHolder().unwrapKey().get()).location().getPath();
            if (name.contains("jam")) {
                return JAM;
            }
            if (name.equals("chocolate")) {
                return CHOCOLATE;
            }
            if (name.equals("syrup")) {
                return SYRUP;
            }
            return NONE;
        }

        @NotNull
        public static Pair<Topping, Item> fromItem(Item item) {
            Pair<Topping, Item> ff = Topping.fromFluidItem(item);
            if (ff.getFirst() != NONE) {
                return ff;
            }
            Holder.Reference holder = item.builtInRegistryHolder();
            Topping t = item == Items.SWEET_BERRIES ? JAM : (holder.is(ModTags.SYRUP) ? SYRUP : (item instanceof HoneyBottleItem ? HONEY : (item == Items.COCOA_BEANS && BuiltInRegistries.ITEM.getTag(ModTags.CHOCOLATE_BARS).isEmpty() ? CHOCOLATE : (holder.is(ModTags.CHOCOLATE_BARS) ? CHOCOLATE : NONE))));
            return Pair.of((Object)((Object)t), (Object)ForgeHelper.getCraftingRemainingItem((ItemStack)item.getDefaultInstance()).map(ItemStack::getItem).orElse(Items.AIR));
        }
    }

    public static enum Winding implements StringRepresentable
    {
        NONE("none"),
        CHAIN("chain"),
        ROPE("rope");

        private final String name;

        private Winding(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum PostType implements StringRepresentable
    {
        POST("post", 4),
        PALISADE("palisade", 6),
        WALL("wall", 8),
        BEAM("beam", 10);

        private final String name;
        private final int width;
        private final float offset;

        private PostType(String name, int width) {
            this.name = name;
            this.width = width;
            this.offset = (8.0f - (float)width / 2.0f) / 16.0f;
        }

        public int getWidth() {
            return this.width;
        }

        public float getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static PostType get(BlockState state) {
            return PostType.get(state, false);
        }

        @Nullable
        public static PostType get(BlockState state, boolean needsFullHeight) {
            PostType type = null;
            if (state.is(ModTags.POSTS)) {
                if (!state.hasProperty((Property)BlockStateProperties.AXIS) || state.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y) {
                    type = POST;
                }
            } else if (state.is(ModTags.PALISADES) || CompatHandler.DECO_BLOCKS && DecoBlocksCompat.isPalisade(state)) {
                type = PALISADE;
            } else if (state.is(ModTags.WALLS)) {
                if (state.getBlock() instanceof WallBlock && !((Boolean)state.getValue((Property)WallBlock.UP)).booleanValue()) {
                    if (needsFullHeight && (state.getValue((Property)WallBlock.NORTH_WALL) == WallSide.LOW || state.getValue((Property)WallBlock.WEST_WALL) == WallSide.LOW)) {
                        return null;
                    }
                    type = PALISADE;
                } else {
                    type = WALL;
                }
            } else if (state.is(ModTags.BEAMS)) {
                type = state.hasProperty((Property)BlockStateProperties.ATTACHED) && (Boolean)state.getValue((Property)BlockStateProperties.ATTACHED) != false ? null : BEAM;
            }
            return type;
        }
    }

    public static enum RakeDirection implements StringRepresentable
    {
        NORTH_SOUTH("north_south", Direction.NORTH, Direction.SOUTH),
        EAST_WEST("east_west", Direction.EAST, Direction.WEST),
        SOUTH_EAST("south_east", Direction.SOUTH, Direction.EAST),
        SOUTH_WEST("south_west", Direction.SOUTH, Direction.WEST),
        NORTH_WEST("north_west", Direction.NORTH, Direction.WEST),
        NORTH_EAST("north_east", Direction.NORTH, Direction.EAST);

        private final List<Direction> directions;
        private final String name;

        private RakeDirection(String name, Direction dir1, Direction dir2) {
            this.name = name;
            this.directions = Arrays.asList(dir1, dir2);
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public List<Direction> getDirections() {
            return this.directions;
        }

        public static RakeDirection fromDirections(List<Direction> directions) {
            for (RakeDirection shape : RakeDirection.values()) {
                if (!new HashSet<Direction>(shape.getDirections()).containsAll(directions)) continue;
                return shape;
            }
            return directions.get(0).getAxis() == Direction.Axis.Z ? NORTH_SOUTH : EAST_WEST;
        }
    }

    public static enum DisplayStatus implements StringRepresentable
    {
        NONE,
        EMPTY,
        FULL;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getSerializedName() {
            return this.toString();
        }

        public boolean hasTile() {
            return this != NONE;
        }

        public boolean hasItem() {
            return this == FULL;
        }
    }

    public static enum Rune implements StringRepresentable
    {
        A("a"),
        B("b"),
        C("c"),
        D("d"),
        E("e"),
        F("f"),
        G("g"),
        H("h"),
        I("i"),
        J("j"),
        K("k"),
        L("l"),
        M("m"),
        N("n"),
        O("o"),
        P("p"),
        Q("q"),
        R("r"),
        S("s"),
        T("t"),
        U("u"),
        V("v"),
        W("w"),
        X("x"),
        Y("y"),
        Z("z");

        private final String name;

        private Rune(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum Bunting implements StringRepresentable
    {
        NONE,
        ROPE,
        BUNTING;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getSerializedName() {
            return this.toString();
        }

        public boolean isConnected() {
            return this != NONE;
        }

        public boolean hasBunting() {
            return this == BUNTING;
        }
    }
}

