/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class CannonScreen
extends AbstractContainerScreen<CannonContainerMenu>
implements ContainerListener {
    private final CannonBlockTile tile;
    private NumberEditBox pitchSelector;
    private NumberEditBox yawSelector;
    private PowerSelectorWidget powerSelector;

    public CannonScreen(CannonContainerMenu menu, Inventory inventory, Component text) {
        super((AbstractContainerMenu)menu, inventory, text);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.tile = menu.getContainer();
    }

    public void init() {
        super.init();
        this.titleLabelX = 8;
        int i = this.leftPos;
        int j = this.topPos;
        this.addRenderableWidget((GuiEventListener)new ManeuverButton(this, i + 154, j + 10 + 6));
        this.yawSelector = (NumberEditBox)this.addRenderableWidget((GuiEventListener)new NumberEditBox(this.font, i + 144, j + 49 + 6, 18, 10));
        this.yawSelector.setNumber(this.tile.getYaw());
        this.pitchSelector = (NumberEditBox)this.addRenderableWidget((GuiEventListener)new NumberEditBox(this.font, i + 144, j + 29 + 6, 18, 10));
        this.pitchSelector.setNumber(this.tile.getPitch());
        this.powerSelector = (PowerSelectorWidget)this.addRenderableWidget((GuiEventListener)new PowerSelectorWidget(i + 18, j + 24, 4));
        this.powerSelector.power = this.tile.getPowerLevel();
        ((CannonContainerMenu)this.menu).addSlotListener(this);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void onManeuverPressed(Button button) {
        CannonController.startControlling(this.tile);
        this.onClose();
    }

    public void onClose() {
        super.onClose();
        float yaw = this.yawSelector.getNumber();
        float pitch = this.pitchSelector.getNumber();
        byte power = this.powerSelector.getPower();
        this.tile.setAttributes(yaw, pitch, power, false, (Player)this.minecraft.player);
        CannonBlockTile.syncToServer(this.tile, false, !CannonController.isActive());
    }

    private int getActualPower() {
        return Math.min(this.powerSelector.getPower(), this.tile.getFuel().getCount());
    }

    public void slotChanged(AbstractContainerMenu container, int slot, ItemStack stack) {
        if (slot == 0) {
            // empty if block
        }
    }

    public void dataChanged(AbstractContainerMenu container, int dataSlotIndex, int value) {
        this.slotChanged(container, 0, container.getSlot(0).getItem());
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        graphics.blit(ModTextures.CANNON_GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        int color = 0x404040;
        byte wantedPower = this.powerSelector.getPower();
        if (wantedPower > this.getActualPower()) {
            color = ChatFormatting.GRAY.getColor();
        }
        graphics.drawString(this.font, wantedPower + "x", 37, 25, color, false);
    }

    public boolean keyPressed(int key, int a, int b) {
        return super.keyPressed(key, a, b);
    }

    public void removed() {
        super.removed();
        ((CannonContainerMenu)this.menu).removeSlotListener(this);
    }

    private final class ManeuverButton
    extends Button {
        public ManeuverButton(CannonScreen cannonScreen, int x, int y) {
            super(x, y, 10, 10, (Component)Component.empty(), cannonScreen::onManeuverPressed, Button.DEFAULT_NARRATION);
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.supplementaries.cannon.maneuver")));
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
            ResourceLocation texture = this.isHovered() ? ModTextures.CANNON_MANEUVER_HOVERED_SPRITE : ModTextures.CANNON_MANEUVER_SPRITE;
            guiGraphics.blitSprite(texture, this.getX(), this.getY(), this.width, this.height);
        }
    }

    private static class NumberEditBox
    extends EditBox {
        public NumberEditBox(Font font, int x, int y, int width, int height) {
            super(font, x, y, width, height, (Component)Component.empty());
            this.setMaxLength(4);
            this.setBordered(false);
            this.setFilter(this::isValidAngle);
        }

        private boolean isValidAngle(String str) {
            try {
                if (str.isEmpty() || str.equals("+") || str.equals("-")) {
                    return true;
                }
                double d = Double.parseDouble(str);
                if (str.contains("[a-zA-Z]+")) {
                    return false;
                }
                return d <= 360.0 && d >= -360.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public void setNumber(float value) {
            this.setValue(String.valueOf((int)value));
        }

        public float getNumber() {
            try {
                return Float.parseFloat(this.getValue());
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
    }

    private class PowerSelectorWidget
    extends AbstractWidget {
        private final byte levels;
        private byte power;

        public PowerSelectorWidget(int x, int y, int levels) {
            super(x, y, 12, 36, (Component)Component.empty());
            this.power = (byte)2;
            this.levels = (byte)levels;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
            byte hoveredLevel = 0;
            int levelH = this.height / this.levels;
            if (this.isHovered) {
                hoveredLevel = this.getSelectedHoveredLevel(mouseY);
            }
            int actualPower = CannonScreen.this.getActualPower();
            for (int p = 1; p <= this.levels; ++p) {
                boolean hovered;
                int selectedH = levelH * p;
                int y = this.height - selectedH;
                boolean bl = hovered = p == hoveredLevel;
                ResourceLocation texture = p > this.power ? (hovered ? ModTextures.CANNON_EMPTY_HOVERED_SPRITE : ModTextures.CANNON_EMPTY_SPRITE) : (p > actualPower ? (hovered ? ModTextures.CANNON_DEPLETED_HOVERED_SPRITE : ModTextures.CANNON_DEPLETED_SPRITE) : (hovered ? ModTextures.CANNON_POWER_HOVERED_SPRITE : ModTextures.CANNON_POWER_SPRITE));
                guiGraphics.blitSprite(texture, this.width, this.height, 0, y, this.getX(), this.getY() + y, this.width, levelH);
            }
        }

        public void onClick(double mouseX, double mouseY) {
            this.power = this.getSelectedHoveredLevel(mouseY);
        }

        private byte getSelectedHoveredLevel(double mouseY) {
            float levelH = (float)this.height / (float)this.levels;
            return (byte)((double)this.levels - Math.floor((mouseY - (double)this.getY()) / (double)levelH));
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public byte getPower() {
            return this.power;
        }
    }
}

