/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BuntingBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BuntingBlockTileRenderer
implements BlockEntityRenderer<BuntingBlockTile> {
    private static ModelPart MODEL;
    private static ModelPart FLAG;
    private static ModelPart BOX;

    public BuntingBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        MODEL = context.bakeLayer(ClientRegistry.BUNTING_MODEL);
        FLAG = MODEL.getChild("flag");
        BOX = MODEL.getChild("box");
    }

    public AABB getRenderBoundingBox(BuntingBlockTile tile) {
        return new AABB(tile.getBlockPos());
    }

    public boolean shouldRender(BuntingBlockTile blockEntity, Vec3 cameraPos) {
        return blockEntity.shouldRenderFancy(cameraPos);
    }

    public void render(BuntingBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        BlockPos pos = tile.getBlockPos();
        long l = tile.getLevel().getGameTime();
        for (Map.Entry<Direction, DyeColor> e : tile.getBuntings().entrySet()) {
            BuntingBlockTileRenderer.renderBunting(e.getValue(), e.getKey(), partialTicks, poseStack, null, bufferIn, combinedLightIn, combinedOverlayIn, pos, l);
        }
        poseStack.popPose();
    }

    public static void renderBunting(DyeColor color, Direction dir, float partialTicks, PoseStack poseStack, @Nullable VertexConsumer vertexConsumer, @Nullable MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn, BlockPos pos, long l) {
        if (color != null) {
            VertexConsumer wrapped;
            poseStack.pushPose();
            Vector3f step = dir.step().mul(0.25f);
            poseStack.mulPose(RotHlpr.rot((Direction)dir));
            poseStack.translate(0.0, 0.0, -0.25);
            poseStack.scale(1.0f, -1.0f, -1.0f);
            Material mat = ModMaterials.BUNTING_MATERIAL.get(color);
            if (buffer != null) {
                float h = ((float)Math.floorMod((long)(((float)pos.getX() + step.x) * 7.0f + ((float)pos.getY() + step.y) * 9.0f + ((float)pos.getZ() + step.z) * 13.0f) + l, 100L) + partialTicks) / 100.0f;
                int i = dir.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1 : -1;
                BuntingBlockTileRenderer.FLAG.zRot = (float)i * 0.01f * Mth.cos((float)((float)Math.PI * 2 * h)) * (float)Math.PI;
                wrapped = mat.buffer(buffer, RenderType::entityCutout);
            } else {
                BuntingBlockTileRenderer.FLAG.xRot = 0.0f;
                wrapped = mat.sprite().wrap(vertexConsumer);
            }
            BuntingBlockTileRenderer.BOX.xScale = 1.0f;
            BuntingBlockTileRenderer.BOX.yScale = 1.1f;
            BuntingBlockTileRenderer.BOX.zScale = 1.1f;
            MODEL.render(poseStack, wrapped, combinedLightIn, combinedOverlayIn);
            poseStack.popPose();
        }
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("flag", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        partdefinition.addOrReplaceChild("box", CubeListBuilder.create().texOffs(0, 12).addBox(-4.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }
}

