/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.cannon.ShootingMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record CannonTrajectory(Vec2 point, float pitch, double finalTime, boolean miss, float gravity, float drag, float v0x, float v0y) {
    public static CannonTrajectory of(Vec2 point, float pitch, double finalTime, boolean miss, float gravity, float drag, float pow) {
        return new CannonTrajectory(point, pitch, finalTime, miss, gravity, drag, (float)(Math.cos(pitch) * (double)pow), (float)(Math.sin(pitch) * (double)pow));
    }

    @Nullable
    public static CannonTrajectory findBest(Vec2 targetPoint, float gravity, float drag, float initialPow, ShootingMode mode, float minPitch, float maxPitch) {
        double targetAngle = Math.atan2(targetPoint.y, targetPoint.x);
        if (gravity == 0.0f || mode == ShootingMode.STRAIGHT) {
            double t;
            float v0x = Mth.cos((float)((float)targetAngle)) * initialPow;
            float v0y = Mth.sin((float)((float)targetAngle)) * initialPow;
            if (drag == 0.0f || drag == 1.0f || mode == ShootingMode.STRAIGHT) {
                return new CannonTrajectory(targetPoint, (float)targetAngle, 6.0, true, gravity, 1.0f, v0x, v0y);
            }
            float finalDist = targetPoint.length();
            double ld = Math.log(drag);
            double arg = 1.0 + (double)finalDist * ld / (double)initialPow;
            boolean miss = false;
            if (arg < 0.0) {
                miss = true;
                t = Math.log(0.4 / (double)initialPow) / Math.log(drag);
            } else {
                t = Math.log(arg) / ld;
            }
            float arcx = (float)CannonTrajectory.arcX(t, gravity, drag, v0x);
            float arcy = (float)CannonTrajectory.arcY(t, gravity, drag, v0y);
            Vec2 pointHit = new Vec2(arcx, arcy);
            return new CannonTrajectory(pointHit, (float)targetAngle, t, miss, gravity, drag, v0x, v0y);
        }
        if (initialPow == 0.0f) {
            return null;
        }
        float tolerance = 0.001f;
        float start = (float)targetAngle + 0.01f;
        float end = 1.5707964f;
        Vec2 farAway = targetPoint.scale(1000.0f);
        CannonTrajectory furthestTrajectory = CannonTrajectory.findBestTrajectoryGoldenSection(farAway, gravity, drag, initialPow, 0.01f, tolerance, start, end);
        float peakAngle = furthestTrajectory.pitch();
        CannonTrajectory solution = mode == ShootingMode.DOWN && minPitch < peakAngle ? CannonTrajectory.findBestTrajectoryGoldenSection(targetPoint, gravity, drag, initialPow, 0.001f, tolerance, Math.max(start, minPitch), Math.min(peakAngle, maxPitch)) : CannonTrajectory.findBestTrajectoryGoldenSection(targetPoint, gravity, drag, initialPow, 0.001f, tolerance, Math.max(peakAngle, minPitch), Math.min(end, maxPitch));
        return solution;
    }

    private static CannonTrajectory findBestTrajectoryBruteForce(float step, Vec2 targetPoint, float gravity, float drag, float initialPow) {
        boolean exitEarly = true;
        float stopDistance = 0.01f;
        float targetSlope = targetPoint.y / targetPoint.x;
        float start = (float)(57.2957763671875 * Mth.atan2((double)targetPoint.y, (double)targetPoint.x)) + 0.01f;
        float end = 90.0f;
        Vec2 bestPoint = new Vec2(0.0f, 0.0f);
        float bestAngle = start;
        double bestPointTime = 0.0;
        float bestV0x = 0.0f;
        float bestV0y = 0.0f;
        boolean miss = true;
        for (float angle = start; angle < end; angle += step) {
            float v0y;
            float rad = angle * ((float)Math.PI / 180);
            float v0x = Mth.cos((float)rad) * initialPow;
            Pair<Vec2, Double> r = CannonTrajectory.findLineIntersection(targetSlope, gravity, drag, v0x, v0y = Mth.sin((float)rad) * initialPow, stopDistance);
            if (r != null) {
                float lastBestDist;
                Vec2 landPoint = (Vec2)r.getFirst();
                float landDist = targetPoint.distanceToSqr(landPoint);
                if (!(landDist < (lastBestDist = targetPoint.distanceToSqr(bestPoint)))) continue;
                bestPoint = landPoint;
                bestAngle = rad;
                bestPointTime = (Double)r.getSecond();
                bestV0x = v0x;
                bestV0y = v0y;
                if (!(landDist < stopDistance)) continue;
                miss = false;
                bestPoint = targetPoint;
                if (!exitEarly) continue;
                break;
            }
            Supplementaries.error();
        }
        return new CannonTrajectory(bestPoint, bestAngle, bestPointTime, miss, gravity, drag, bestV0x, bestV0y);
    }

    private static CannonTrajectory findBestTrajectorySecant(Vec2 targetPoint, float gravity, float drag, float initialPow, float tolerance, int maxIterations) {
        float targetSlope = targetPoint.y / targetPoint.x;
        float startAngle = (float)Math.atan2(targetPoint.y, targetPoint.x) + 0.01f;
        float endAngle = 1.5707964f;
        float angle1 = startAngle;
        float angle2 = endAngle;
        Vec2 bestPoint = new Vec2(0.0f, 0.0f);
        float bestAngle = startAngle;
        double bestPointTime = 0.0;
        float bestV0x = 0.0f;
        float bestV0y = 0.0f;
        boolean miss = true;
        float bestDistance = Float.MAX_VALUE;
        for (int i = 0; i < maxIterations; ++i) {
            float distToTarget;
            float distance2;
            float v0x1 = (float)(Math.cos(angle1) * (double)initialPow);
            float v0y1 = (float)(Math.sin(angle1) * (double)initialPow);
            float v0x2 = (float)(Math.cos(angle2) * (double)initialPow);
            float v0y2 = (float)(Math.sin(angle2) * (double)initialPow);
            Pair<Vec2, Double> r1 = CannonTrajectory.findLineIntersection(targetSlope, gravity, drag, v0x1, v0y1, tolerance);
            Pair<Vec2, Double> r2 = CannonTrajectory.findLineIntersection(targetSlope, gravity, drag, v0x2, v0y2, tolerance);
            float distance1 = r1 != null ? targetPoint.distanceToSqr((Vec2)r1.getFirst()) : Float.MAX_VALUE;
            float f = distance2 = r2 != null ? targetPoint.distanceToSqr((Vec2)r2.getFirst()) : Float.MAX_VALUE;
            if (distance1 < distance2) {
                bestPoint = (Vec2)r1.getFirst();
                bestAngle = angle1;
                bestPointTime = (Double)r1.getSecond();
                bestV0x = v0x1;
                bestV0y = v0y1;
                angle2 = angle1;
                angle1 -= tolerance;
                distToTarget = distance1;
            } else {
                bestPoint = (Vec2)r2.getFirst();
                bestAngle = angle2;
                bestPointTime = (Double)r2.getSecond();
                bestV0x = v0x2;
                bestV0y = v0y2;
                angle1 = angle2;
                angle2 += tolerance;
                distToTarget = distance2;
            }
            bestDistance = distToTarget;
            float distanceIncrease = Math.abs(distance1 - distance2);
            if (distanceIncrease < tolerance) break;
            if (!(distToTarget < tolerance)) continue;
            miss = false;
            bestPoint = targetPoint;
            break;
        }
        return new CannonTrajectory(bestPoint, bestAngle, bestPointTime, miss, gravity, drag, bestV0x, bestV0y);
    }

    private static CannonTrajectory findBestTrajectoryGoldenSection(Vec2 targetPoint, float gravity, float drag, float initialPow, float angleTolerance, float tolerance, float start, float end) {
        float targetSlope = targetPoint.y / targetPoint.x;
        float goldenRatio = MthUtils.PHI - 1.0f;
        Vec2 bestPoint = new Vec2(0.0f, 0.0f);
        float bestAngle = start;
        double bestPointTime = 0.0;
        float bestV0x = 0.0f;
        float bestV0y = 0.0f;
        boolean miss = true;
        float startAngle = start;
        float endAngle = end;
        float midAngle1 = startAngle + goldenRatio * (endAngle - startAngle);
        float midAngle2 = endAngle - goldenRatio * (endAngle - startAngle);
        int iterNumber = 0;
        while (Math.abs(endAngle - startAngle) > angleTolerance) {
            float distance2;
            ++iterNumber;
            float v0x1 = (float)(Math.cos(midAngle1) * (double)initialPow);
            float v0y1 = (float)(Math.sin(midAngle1) * (double)initialPow);
            float v0x2 = (float)(Math.cos(midAngle2) * (double)initialPow);
            float v0y2 = (float)(Math.sin(midAngle2) * (double)initialPow);
            Pair<Vec2, Double> r1 = CannonTrajectory.findLineIntersection(targetSlope, gravity, drag, v0x1, v0y1, tolerance);
            Pair<Vec2, Double> r2 = CannonTrajectory.findLineIntersection(targetSlope, gravity, drag, v0x2, v0y2, tolerance);
            float distance1 = r1 != null ? targetPoint.distanceToSqr((Vec2)r1.getFirst()) : Float.MAX_VALUE;
            float f = distance2 = r2 != null ? targetPoint.distanceToSqr((Vec2)r2.getFirst()) : Float.MAX_VALUE;
            if (midAngle1 < midAngle2) {
                Supplementaries.error();
            }
            float lastBestDist = targetPoint.distanceToSqr(bestPoint);
            if (distance1 < distance2) {
                if (r1 == null) break;
                bestPoint = (Vec2)r1.getFirst();
                bestAngle = midAngle1;
                bestPointTime = (Double)r1.getSecond();
                bestV0x = v0x1;
                bestV0y = v0y1;
                if (distance1 > lastBestDist && iterNumber != 1) {
                    Supplementaries.error();
                }
                startAngle = midAngle2;
                midAngle2 = midAngle1;
                midAngle1 = startAngle + goldenRatio * (endAngle - startAngle);
            } else {
                if (r2 == null) break;
                bestPoint = (Vec2)r2.getFirst();
                bestAngle = midAngle2;
                bestPointTime = (Double)r2.getSecond();
                bestV0x = v0x2;
                bestV0y = v0y2;
                if (distance2 > lastBestDist && iterNumber != 1) {
                    Supplementaries.error();
                }
                endAngle = midAngle1;
                midAngle1 = midAngle2;
                midAngle2 = endAngle - goldenRatio * (endAngle - startAngle);
            }
            if (endAngle < startAngle) {
                Supplementaries.error();
            }
            if (!(Math.abs(endAngle - startAngle) > angleTolerance)) {
                boolean bl = true;
            }
            if (!(lastBestDist < tolerance * 10.0f)) continue;
            bestPoint = targetPoint;
            miss = false;
            break;
        }
        return new CannonTrajectory(bestPoint, bestAngle, bestPointTime, miss, gravity, drag, bestV0x, bestV0y);
    }

    private static Pair<Vec2, Double> findLineIntersection(float m, float g, float d, float V0x, float V0y, float precision) {
        return CannonTrajectory.findLineIntersectionBisection(m, g, d, V0x, V0y, precision);
    }

    private static Pair<Vec2, Double> findLineIntersectionSecant(float m, float g, float d, float V0x, float V0y) {
        float slopeAt0 = V0y / V0x;
        if (slopeAt0 < m) {
            return null;
        }
        float tolerance = 0.01f;
        int maxIterations = 20;
        double t1 = 20.0;
        double t2 = 50000.0;
        double x1 = CannonTrajectory.arcX(t1, g, d, V0x);
        double x2 = CannonTrajectory.arcX(t2, g, d, V0x);
        double y1 = CannonTrajectory.arcY(t1, g, d, V0y);
        double y2 = CannonTrajectory.arcY(t2, g, d, V0y);
        double xNew = 0.0;
        double yNew = 0.0;
        double tNew = 0.0;
        for (int iter = 0; iter < maxIterations && t1 != t2 && Double.isFinite(tNew = t2 - (y2 - (double)m * x2) * (t2 - t1) / (y2 - y1 - (double)m * (x2 - x1))); ++iter) {
            xNew = CannonTrajectory.arcX(tNew, g, d, V0x);
            yNew = CannonTrajectory.arcY(tNew, g, d, V0y);
            double error = yNew - (double)m * xNew;
            if (Math.abs(error) < (double)tolerance) break;
            t1 = t2;
            t2 = tNew;
            x1 = x2;
            x2 = xNew;
            y1 = y2;
            y2 = yNew;
        }
        if (tNew < 0.0) {
            boolean bl = false;
        }
        return Pair.of((Object)new Vec2((float)xNew, (float)yNew), (Object)tNew);
    }

    private static Pair<Vec2, Double> findLineIntersectionBisection(float m, float g, float d, float V0x, float V0y, float precision) {
        float slopeAt0 = V0y / V0x;
        if (slopeAt0 < m) {
            Supplementaries.error();
            return null;
        }
        double low = 0.0;
        double high = 1000.0;
        int iter = 0;
        int maxIter = 50;
        while (iter++ < maxIter) {
            double xNew;
            double yLine;
            double midTime = (low + high) / 2.0;
            double yNew = CannonTrajectory.arcY(midTime, g, d, V0y);
            if (Math.abs(yNew - (yLine = (double)m * (xNew = CannonTrajectory.arcX(midTime, g, d, V0x)))) < (double)precision) {
                return Pair.of((Object)new Vec2((float)xNew, (float)yNew), (Object)midTime);
            }
            if (yNew > yLine) {
                low = midTime;
                continue;
            }
            high = midTime;
        }
        Supplementaries.error();
        return null;
    }

    private static void projectileEquation() {
    }

    public static double arcY(double t, float g, float d, float V0y) {
        if (d == 1.0f) {
            return (double)V0y * t;
        }
        float k = g / (d - 1.0f);
        double inLog = 1.0 / Math.log(d);
        return (double)(V0y - k) * inLog * (Math.pow(d, t) - 1.0) + (double)k * t;
    }

    public static double arcX(double t, float g, float d, float V0x) {
        if (d == 1.0f) {
            return (double)V0x * t;
        }
        double inLog = 1.0 / Math.log(d);
        return (double)V0x * inLog * (Math.pow(d, t) - 1.0);
    }

    public double getX(double t) {
        return CannonTrajectory.arcX(t, this.gravity, this.drag, this.v0x);
    }

    public double getY(double t) {
        return CannonTrajectory.arcY(t, this.gravity, this.drag, this.v0y);
    }

    public BlockPos getHitPos(BlockPos cannonPos, float yaw) {
        Vec2 v = this.point;
        Vec3 localPos = new Vec3(0.0, (double)v.y, (double)(-v.x)).yRot(-yaw);
        float offsetDown = -0.0625f;
        return BlockPos.containing((Position)cannonPos.getCenter().add(localPos).add(0.0, (double)offsetDown, 0.0));
    }
}

