/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.client.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestOpenCannonGuiMessage;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CannonController {
    protected static CannonBlockTile cannon;
    private static CameraType lastCameraType;
    protected static HitResult hit;
    private static boolean firstTick;
    private static float yawIncrease;
    private static float pitchIncrease;
    private static boolean needsToUpdateServer;
    protected static ShootingMode shootingMode;
    @Nullable
    protected static CannonTrajectory trajectory;
    private static Vec3 lastCameraPos;
    private static float lastZoomOut;
    private static float lastCameraYaw;
    private static float lastCameraPitch;
    protected static boolean showsTrajectory;

    public static void startControlling(CannonBlockTile tile) {
        firstTick = true;
        Minecraft mc = Minecraft.getInstance();
        if (cannon == null) {
            cannon = tile;
            shootingMode = cannon.getTrajectoryData().drag() != 0.0f ? ShootingMode.DOWN : ShootingMode.STRAIGHT;
            lastCameraType = mc.options.getCameraType();
        }
        mc.options.setCameraType(CameraType.THIRD_PERSON_BACK);
        mc.gui.setOverlayMessage((Component)Component.translatable((String)"message.supplementaries.cannon_maneuver", (Object[])new Object[]{mc.options.keyShift.getTranslatedKeyMessage(), mc.options.keyAttack.getTranslatedKeyMessage()}), false);
    }

    private static void stopControllingAndSync() {
        if (cannon == null) {
            return;
        }
        CannonBlockTile.syncToServer(cannon, false, true);
        CannonController.stopControlling();
    }

    public static void stopControlling() {
        if (cannon == null) {
            return;
        }
        cannon = null;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        lastZoomOut = 0.0f;
        lastCameraPos = null;
        if (lastCameraType != null) {
            Minecraft.getInstance().options.setCameraType(lastCameraType);
        }
    }

    public static boolean isActive() {
        return cannon != null;
    }

    public static boolean setupCamera(Camera camera, BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (CannonController.isActive()) {
            Vec3 centerCannonPos = cannon.getBlockPos().getCenter();
            if (lastCameraPos == null) {
                lastCameraPos = camera.getPosition();
                lastCameraYaw = camera.getYRot();
                lastCameraPitch = camera.getXRot();
            }
            Vec3 targetCameraPos = centerCannonPos.add(0.0, 2.0, 0.0);
            float targetYRot = camera.getYRot() + yawIncrease;
            float targetXRot = Mth.clamp((float)(camera.getXRot() + pitchIncrease), (float)-90.0f, (float)90.0f);
            camera.setPosition(targetCameraPos);
            camera.setRotation(targetYRot, targetXRot);
            lastCameraPos = camera.getPosition();
            lastCameraYaw = camera.getYRot();
            lastCameraPitch = camera.getXRot();
            lastZoomOut = camera.getMaxZoom(4.0f);
            float horizontalOffset = -1.0f;
            camera.move(-lastZoomOut, 0.0f, horizontalOffset);
            yawIncrease = 0.0f;
            pitchIncrease = 0.0f;
            if (!cannon.isFiring()) {
                Vec3 lookDir2 = new Vec3(camera.getLookVector());
                float maxRange = 128.0f;
                Vec3 actualCameraPos = camera.getPosition().add(lookDir2.normalize());
                Vec3 endPos = actualCameraPos.add(lookDir2.scale((double)maxRange));
                hit = level.clip(new ClipContext(actualCameraPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, entity));
                Vec3 targetVector = hit.getLocation().subtract(cannon.getBlockPos().getCenter());
                Vec2 target = new Vec2((float)Mth.length((double)targetVector.x, (double)targetVector.z), (float)targetVector.y);
                target = target.add(target.normalized().scale(0.05f));
                float wantedCannonYaw = (float)Math.PI + (float)Mth.atan2((double)(-targetVector.x), (double)targetVector.z);
                CannonBlockTile.Restraint restraints = cannon.getPitchAndYawRestrains();
                IBallisticBehavior.Data ballistic = cannon.getTrajectoryData();
                trajectory = CannonTrajectory.findBest(target, ballistic.gravity(), ballistic.drag(), cannon.getFirePower() * ballistic.initialSpeed(), shootingMode, restraints.minPitch(), restraints.maxPitch());
                if (trajectory != null) {
                    CannonController.setCannonAngles(partialTick, wantedCannonYaw * 57.295776f);
                }
            }
            return true;
        }
        return false;
    }

    private static void setCannonAngles(float partialTick, float targetYawDeg) {
        float followSpeed = 1.0f;
        cannon.setRestrainedPitch(Mth.rotLerp((float)followSpeed, (float)cannon.getPitch(), (float)(trajectory.pitch() * 57.295776f)));
        cannon.setRenderYaw(targetYawDeg);
    }

    public static boolean onPlayerRotated(double yawAdd, double pitchAdd) {
        if (CannonController.isActive()) {
            float scale = 0.2f;
            yawIncrease += (float)(yawAdd * (double)scale);
            pitchIncrease += (float)(pitchAdd * (double)scale);
            if (yawAdd != 0.0 || pitchAdd != 0.0) {
                needsToUpdateServer = true;
            }
            return true;
        }
        return false;
    }

    public static void onKeyJump() {
        if (trajectory != null && trajectory.gravity() != 0.0f) {
            shootingMode = shootingMode.cycle();
            needsToUpdateServer = true;
        }
    }

    public static void onKeyInventory() {
        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundRequestOpenCannonGuiMessage(cannon.getBlockPos()));
    }

    public static void onKeyShift() {
        CannonController.stopControllingAndSync();
    }

    public static void onMouseScrolled(double scrollDelta) {
        if (scrollDelta != 0.0) {
            cannon.changeFirePower((int)scrollDelta);
            needsToUpdateServer = true;
        }
    }

    public static void onPlayerAttack() {
        if (cannon != null && cannon.readyToFire()) {
            CannonBlockTile.syncToServer(cannon, true, false);
        }
    }

    public static void onPlayerUse() {
        showsTrajectory = !showsTrajectory;
    }

    public static void onInputUpdate(Input input) {
        if (firstTick) {
            firstTick = false;
            input.down = false;
            input.jumping = false;
            input.up = false;
            input.left = false;
            input.right = false;
            input.shiftKeyDown = false;
            input.forwardImpulse = 0.0f;
            input.leftImpulse = 0.0f;
        }
    }

    public static void onClientTick(Minecraft mc) {
        if (!CannonController.isActive()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Level level = player.level();
        BlockPos pos = cannon.getBlockPos();
        float maxDist = 7.0f;
        if (level.getBlockEntity(pos) == cannon && !cannon.isRemoved() && pos.distToCenterSqr((Position)player.position()) < (double)(maxDist * maxDist)) {
            if (needsToUpdateServer) {
                needsToUpdateServer = false;
                CannonBlockTile.syncToServer(cannon, false, false);
            }
        } else {
            CannonController.stopControllingAndSync();
        }
    }

    static {
        firstTick = true;
        shootingMode = ShootingMode.DOWN;
        lastZoomOut = 0.0f;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        showsTrajectory = true;
    }
}

