/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.data.tag.CustomTagEntrySerializer;
import com.supermartijn642.core.extensions.CoreLibMappedRegistry;
import com.supermartijn642.core.util.MappedSetView;
import com.supermartijn642.core.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class Registries {
    static final Map<ResourceLocation, Registry<?>> IDENTIFIER_TO_REGISTRY = new HashMap();
    static final Map<net.minecraft.core.Registry<?>, Registry<?>> VANILLA_REGISTRY_MAP = new HashMap();
    static final Map<Registry<?>, List<Registry<?>>> REGISTRATION_ORDER_MAP = new HashMap();
    public static final Registry<Block> BLOCKS = Registries.vanilla(BuiltInRegistries.BLOCK, Block.class);
    public static final Registry<Fluid> FLUIDS = Registries.vanilla(BuiltInRegistries.FLUID, Fluid.class);
    public static final Registry<Item> ITEMS = Registries.vanilla(BuiltInRegistries.ITEM, Item.class);
    public static final Registry<MobEffect> MOB_EFFECTS = Registries.vanilla(BuiltInRegistries.MOB_EFFECT, MobEffect.class);
    public static final Registry<SoundEvent> SOUND_EVENTS = Registries.vanilla(BuiltInRegistries.SOUND_EVENT, SoundEvent.class);
    public static final Registry<Potion> POTIONS = Registries.vanilla(BuiltInRegistries.POTION, Potion.class);
    public static final Registry<EntityType<?>> ENTITY_TYPES = Registries.vanilla(BuiltInRegistries.ENTITY_TYPE, EntityType.class);
    public static final Registry<BlockEntityType<?>> BLOCK_ENTITY_TYPES = Registries.vanilla(BuiltInRegistries.BLOCK_ENTITY_TYPE, BlockEntityType.class);
    public static final Registry<ParticleType<?>> PARTICLE_TYPES = Registries.vanilla(BuiltInRegistries.PARTICLE_TYPE, ParticleType.class);
    public static final Registry<MenuType<?>> MENU_TYPES = Registries.vanilla(BuiltInRegistries.MENU, MenuType.class);
    public static final Registry<RecipeType<?>> RECIPE_TYPES = Registries.vanilla(BuiltInRegistries.RECIPE_TYPE, RecipeType.class);
    public static final Registry<RecipeSerializer<?>> RECIPE_SERIALIZERS = Registries.vanilla(BuiltInRegistries.RECIPE_SERIALIZER, RecipeSerializer.class);
    public static final Registry<Attribute> ATTRIBUTES = Registries.vanilla(BuiltInRegistries.ATTRIBUTE, Attribute.class);
    public static final Registry<StatType<?>> STAT_TYPES = Registries.vanilla(BuiltInRegistries.STAT_TYPE, StatType.class);
    public static final Registry<MapCodec<? extends ICondition>> RECIPE_CONDITION_SERIALIZERS = Registries.vanilla(NeoForgeRegistries.CONDITION_SERIALIZERS, MapCodec.class);
    public static final Registry<CustomTagEntrySerializer<?>> CUSTOM_TAG_ENTRY_SERIALIZERS = new MapBackedRegistry<CustomTagEntrySerializer>(ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"custom_tag_entries"), CustomTagEntrySerializer.class);
    public static final Registry<DataComponentType<?>> DATA_COMPONENT_TYPES = Registries.vanilla(BuiltInRegistries.DATA_COMPONENT_TYPE, DataComponentType.class);
    public static final Registry<CriterionTrigger<?>> TRIGGER_TYPES = Registries.vanilla(BuiltInRegistries.TRIGGER_TYPES, CriterionTrigger.class);

    private static void addRegistry(Registry<?> registry) {
        if (IDENTIFIER_TO_REGISTRY.containsKey(registry.getRegistryIdentifier())) {
            throw new RuntimeException("Duplicate registry registration for identifier '" + String.valueOf(registry.getRegistryIdentifier()) + "'!");
        }
        if (registry.hasVanillaRegistry() && VANILLA_REGISTRY_MAP.containsKey(registry.getVanillaRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + String.valueOf(registry.getValueClass()) + "'!");
        }
        IDENTIFIER_TO_REGISTRY.put(registry.getRegistryIdentifier(), registry);
        if (registry.hasVanillaRegistry()) {
            VANILLA_REGISTRY_MAP.put(registry.getVanillaRegistry(), registry);
        }
    }

    @ApiStatus.Internal
    public static <T> Registry<T> fromUnderlying(net.minecraft.core.Registry<T> registry) {
        return VANILLA_REGISTRY_MAP.get(registry);
    }

    public static Registry<?> getRegistry(ResourceLocation identifier) {
        return IDENTIFIER_TO_REGISTRY.get(identifier);
    }

    private static <T> Registry<T> vanilla(net.minecraft.core.Registry<T> registry, Class<? super T> valueClass) {
        return new VanillaRegistryWrapper<T>(registry, valueClass);
    }

    static {
        REGISTRATION_ORDER_MAP.put(RECIPE_SERIALIZERS, Lists.newArrayList((Object[])new Registry[]{CUSTOM_TAG_ENTRY_SERIALIZERS}));
    }

    public static interface Registry<T> {
        public ResourceLocation getRegistryIdentifier();

        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry();

        public boolean hasVanillaRegistry();

        public void register(ResourceLocation var1, T var2);

        public ResourceLocation getIdentifier(T var1);

        public boolean hasIdentifier(ResourceLocation var1);

        public T getValue(ResourceLocation var1);

        public Set<ResourceLocation> getIdentifiers();

        public Collection<T> getValues();

        public Set<Pair<ResourceLocation, T>> getEntries();

        public Class<T> getValueClass();
    }

    private static class VanillaRegistryWrapper<T>
    implements Registry<T> {
        private final net.minecraft.core.Registry<T> registry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private VanillaRegistryWrapper(net.minecraft.core.Registry<T> registry, Class<? super T> valueClass) {
            this.registry = registry;
            this.identifier = registry.key().location();
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Deprecated
        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return true;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            if (this.registry instanceof MappedRegistry && this.registry.containsKey(identifier)) {
                ResourceKey key = ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)identifier);
                ((CoreLibMappedRegistry)this.registry).supermartijn642corelibSetRegisterOverrides(true);
                ((MappedRegistry)this.registry).register(key, object, RegistrationInfo.BUILT_IN);
                ((CoreLibMappedRegistry)this.registry).supermartijn642corelibSetRegisterOverrides(false);
                return;
            }
            net.minecraft.core.Registry.register(this.registry, (ResourceLocation)identifier, object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.registry.getKey(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.registry.containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.registry.get(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.registry.keySet();
        }

        @Override
        public Collection<T> getValues() {
            return MappedSetView.map(this.registry.entrySet(), Map.Entry::getValue);
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(this.registry.entrySet(), entry -> Pair.of(((ResourceKey)entry.getKey()).location(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            int result = this.registry.hashCode();
            result = 31 * result + this.valueClass.hashCode();
            return result;
        }
    }

    private static class MapBackedRegistry<T>
    implements Registry<T> {
        private final ResourceLocation identifier;
        private final Map<ResourceLocation, T> identifierToObject = new HashMap<ResourceLocation, T>();
        private final Map<T, ResourceLocation> objectToIdentifier = new HashMap<T, ResourceLocation>();
        private final Set<Pair<ResourceLocation, T>> entries = new HashSet<Pair<ResourceLocation, T>>();
        private final Class<T> valueClass;

        private MapBackedRegistry(ResourceLocation identifier, Class<? super T> valueClass) {
            this.identifier = identifier;
            this.valueClass = valueClass;
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        public @Nullable net.minecraft.core.Registry<T> getVanillaRegistry() {
            return null;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            if (this.identifierToObject.containsKey(identifier)) {
                throw new RuntimeException("Duplicate registry for identifier '" + String.valueOf(identifier) + "'!");
            }
            if (this.objectToIdentifier.containsKey(object)) {
                throw new RuntimeException("Duplicate registry for object under '" + String.valueOf(this.objectToIdentifier.get(object)) + "' and '" + String.valueOf(identifier) + "'!");
            }
            this.identifierToObject.put(identifier, object);
            this.objectToIdentifier.put(object, identifier);
            this.entries.add(Pair.of(identifier, object));
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.objectToIdentifier.get(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.identifierToObject.containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return this.identifierToObject.get(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return Collections.unmodifiableSet(this.identifierToObject.keySet());
        }

        @Override
        public Collection<T> getValues() {
            return Collections.unmodifiableCollection(this.objectToIdentifier.keySet());
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return Collections.unmodifiableSet(this.entries);
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }
    }
}

