/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget;

import com.supermartijn642.core.gui.widget.ObjectBaseWidget;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class BlockEntityBaseWidget<T extends BlockEntity>
extends ObjectBaseWidget<T> {
    protected final Level blockEntityLevel;
    protected final BlockPos blockEntityPos;

    public BlockEntityBaseWidget(int x, int y, int width, int height, Level blockEntityLevel, BlockPos blockEntityPos) {
        super(x, y, width, height);
        this.blockEntityLevel = blockEntityLevel;
        this.blockEntityPos = blockEntityPos;
    }

    @Override
    protected T getObject(T oldObject) {
        BlockEntity entity = this.blockEntityLevel.getBlockEntity(this.blockEntityPos);
        if (entity == null) {
            return null;
        }
        try {
            return (T)entity;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    protected boolean validateObject(T object) {
        return object != null && !object.isRemoved();
    }
}

