/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.util.IOPool;
import com.ldtteam.structurize.util.ManualBarrier;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import org.jetbrains.annotations.Nullable;

public class StructurePacks {
    private static final int PACK_FORMAT = 1;
    private static final Map<String, StructurePackMeta> packMetas = new ConcurrentHashMap<String, StructurePackMeta>();
    private static final Map<String, StructurePackMeta> clientPackMetas = new ConcurrentHashMap<String, StructurePackMeta>();
    private static final ManualBarrier finishedLoading = new ManualBarrier(false);
    public static StructurePackMeta selectedPack;

    public static boolean waitUntilFinishedLoading() {
        try {
            finishedLoading.waitOne();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static void setFinishedLoading() {
        finishedLoading.open();
    }

    public static Collection<StructurePackMeta> getPackMetas() {
        return packMetas.values();
    }

    @Nullable
    public static StructurePackMeta getStructurePack(String key) {
        if (packMetas.containsKey(key)) {
            return packMetas.get(key);
        }
        return clientPackMetas.get(key);
    }

    public static void clearPacks() {
        packMetas.clear();
        clientPackMetas.clear();
    }

    public static StructurePackMeta disablePack(String name) {
        return packMetas.remove(name);
    }

    public static CompletableFuture<Blueprint> getBlueprintFuture(String structurePackId, String subPath, HolderLookup.Provider provider) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.getBlueprint(structurePackId, subPath, provider), IOPool.getExecutor());
    }

    public static CompletableFuture<byte[]> getBlueprintDataFuture(String structurePackId, String subPath) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.getBlueprintData(structurePackId, subPath), IOPool.getExecutor());
    }

    public static CompletableFuture<Path> findBlueprintFuture(String structurePackId, String name) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.findBlueprint(structurePackId, name), IOPool.getExecutor());
    }

    public static CompletableFuture<List<Blueprint>> getBlueprintsFuture(String structurePackId, String subPath, HolderLookup.Provider provider) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.getBlueprints(structurePackId, subPath, provider), IOPool.getExecutor());
    }

    public static CompletableFuture<List<Category>> getCategoriesFuture(String structurePackId, String subPath) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.getCategories(structurePackId, subPath), IOPool.getExecutor());
    }

    public static CompletableFuture<Blueprint> getBlueprintFuture(String packName, Path path, HolderLookup.Provider provider) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.getBlueprint(packName, path, provider), IOPool.getExecutor());
    }

    public static CompletableFuture<Blueprint> findBlueprintFuture(String structurePackId, Predicate<Blueprint> blueprintPredicate, HolderLookup.Provider provider) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.findBlueprint(structurePackId, blueprintPredicate, provider), IOPool.getExecutor());
    }

    public static CompletableFuture<Blueprint> getBlueprintFuture(String structurePackId, String subPath, boolean suppressError, HolderLookup.Provider provider) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.getBlueprint(structurePackId, subPath, suppressError, provider), IOPool.getExecutor());
    }

    public static CompletableFuture<Blueprint> getBlueprintFuture(String packName, Path path, boolean suppressError, HolderLookup.Provider provider) {
        return CompletableFuture.supplyAsync(() -> StructurePacks.getBlueprint(packName, path, suppressError, provider), IOPool.getExecutor());
    }

    @Nullable
    public static Blueprint getBlueprint(String structurePackId, String subPath, HolderLookup.Provider provider) {
        return StructurePacks.getBlueprint(structurePackId, subPath, false, provider);
    }

    public static Blueprint getBlueprint(String pack, Path path, HolderLookup.Provider provider) {
        return StructurePacks.getBlueprint(pack, path, false, provider);
    }

    public static Path findBlueprint(String structurePackId, String name) {
        if (!StructurePacks.waitUntilFinishedLoading()) {
            return null;
        }
        StructurePackMeta packMeta = StructurePacks.getStructurePack(structurePackId);
        if (packMeta == null) {
            return null;
        }
        return StructurePacks.findBlueprint(packMeta.getPath(), name).orElse(null);
    }

    public static Optional<Path> findBlueprint(Path subPath, String name) {
        Optional<Path> optional;
        block9: {
            if (!StructurePacks.waitUntilFinishedLoading()) {
                return Optional.empty();
            }
            Stream<Path> paths = Files.walk(subPath, new FileVisitOption[0]);
            try {
                optional = paths.filter(file -> {
                    if (!Files.isDirectory(file, new LinkOption[0]) && file.toString().endsWith("blueprint")) {
                        return file.getFileName().toString().replace(".blueprint", "").equals(name);
                    }
                    return false;
                }).findFirst();
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.getLogger().error("Error loading blueprint: " + String.valueOf(subPath) + ":" + name, (Throwable)e);
                    return Optional.empty();
                }
            }
            paths.close();
        }
        return optional;
    }

    public static Blueprint findBlueprint(String structurePackId, Predicate<Blueprint> blueprintPredicate, HolderLookup.Provider provider) {
        if (!StructurePacks.waitUntilFinishedLoading()) {
            return null;
        }
        StructurePackMeta packMeta = StructurePacks.getStructurePack(structurePackId);
        if (packMeta == null) {
            return null;
        }
        return StructurePacks.findBlueprint(packMeta.getName(), packMeta.getPath(), blueprintPredicate, provider);
    }

    public static Blueprint findBlueprint(String pack, Path subPath, Predicate<Blueprint> blueprintPredicate, HolderLookup.Provider provider) {
        Blueprint blueprint;
        block9: {
            if (!StructurePacks.waitUntilFinishedLoading()) {
                return null;
            }
            Stream<Path> paths = Files.list(subPath);
            try {
                blueprint = paths.map(file -> {
                    if (!Files.isDirectory(file, new LinkOption[0]) && file.toString().endsWith("blueprint")) {
                        Blueprint blueprint = StructurePacks.getBlueprint(pack, file, provider);
                        if (blueprintPredicate.test(blueprint)) {
                            blueprint.setFileName(file.getFileName().toString().replace(".blueprint", ""));
                            blueprint.setFilePath(file.getParent()).setPackName(pack);
                            return blueprint;
                        }
                    } else if (Files.isDirectory(file, new LinkOption[0])) {
                        return StructurePacks.findBlueprint(pack, file, blueprintPredicate, provider);
                    }
                    return null;
                }).filter(Objects::nonNull).findFirst().orElse(null);
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.getLogger().error("Error loading blueprint: " + pack + ":" + String.valueOf(subPath), (Throwable)e);
                    return null;
                }
            }
            paths.close();
        }
        return blueprint;
    }

    @Nullable
    public static Blueprint getBlueprint(String structurePackId, String subPath, boolean suppressError, HolderLookup.Provider provider) {
        if (!StructurePacks.waitUntilFinishedLoading()) {
            return null;
        }
        StructurePackMeta packMeta = StructurePacks.getStructurePack(structurePackId);
        if (packMeta == null) {
            return null;
        }
        return StructurePacks.getBlueprint(structurePackId, packMeta.getPath().resolve(packMeta.getNormalizedSubPath(subPath)), suppressError, provider);
    }

    public static Blueprint getBlueprint(String pack, Path path, boolean suppressError, HolderLookup.Provider provider) {
        try {
            CompoundTag nbt = NbtIo.readCompressed((InputStream)new ByteArrayInputStream(Files.readAllBytes(path)), (NbtAccounter)NbtAccounter.unlimitedHeap());
            Blueprint blueprint = BlueprintUtil.readBlueprintFromNBT(nbt, provider);
            if (blueprint == null) {
                return null;
            }
            blueprint.setFileName(path.getFileName().toString().replace(".blueprint", ""));
            blueprint.setFilePath(path.getParent()).setPackName(pack);
            return blueprint;
        }
        catch (IOException e) {
            if (!suppressError) {
                Log.getLogger().error("Error loading blueprint: " + pack + ":" + String.valueOf(path), (Throwable)e);
            }
            return null;
        }
    }

    public static byte[] getBlueprintData(String structurePackId, String subPath) {
        if (!StructurePacks.waitUntilFinishedLoading()) {
            return null;
        }
        StructurePackMeta packMeta = StructurePacks.getStructurePack(structurePackId);
        if (packMeta == null) {
            return null;
        }
        try {
            return Files.readAllBytes(packMeta.getPath().resolve(packMeta.getNormalizedSubPath(subPath)));
        }
        catch (IOException e) {
            Log.getLogger().error("Error reading blueprint data: ", (Throwable)e);
            return null;
        }
    }

    public static List<Blueprint> getBlueprints(String structurePackId, String subPath, HolderLookup.Provider provider) {
        if (!StructurePacks.waitUntilFinishedLoading()) {
            return Collections.emptyList();
        }
        StructurePackMeta packMeta = StructurePacks.getStructurePack(structurePackId);
        if (packMeta == null) {
            return Collections.emptyList();
        }
        ArrayList<Blueprint> blueprints = new ArrayList<Blueprint>();
        try (Stream<Path> paths = Files.list(packMeta.getPath().resolve(packMeta.getNormalizedSubPath(subPath)));){
            paths.forEach(file -> {
                if (!Files.isDirectory(file, new LinkOption[0]) && file.toString().endsWith("blueprint")) {
                    try {
                        CompoundTag nbt = NbtIo.readCompressed((InputStream)new ByteArrayInputStream(Files.readAllBytes(file)), (NbtAccounter)NbtAccounter.unlimitedHeap());
                        Blueprint blueprint = BlueprintUtil.readBlueprintFromNBT(nbt, provider);
                        if (blueprint != null) {
                            blueprint.setFileName(file.getFileName().toString().replace(".blueprint", ""));
                            blueprint.setFilePath(file.getParent()).setPackName(structurePackId);
                            blueprints.add(blueprint);
                        }
                    }
                    catch (IOException e) {
                        Log.getLogger().error("Error loading individual blueprint: " + String.valueOf(file), (Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            Log.getLogger().error("Error loading blueprints from folder: " + packMeta.getNormalizedSubPath(subPath), (Throwable)e);
        }
        blueprints.sort(Comparator.comparing(Blueprint::getFileName));
        return blueprints;
    }

    public static List<Category> getCategories(String structurePackId, String subPath) {
        if (!StructurePacks.waitUntilFinishedLoading()) {
            return Collections.emptyList();
        }
        StructurePackMeta packMeta = StructurePacks.getStructurePack(structurePackId);
        if (packMeta == null) {
            return Collections.emptyList();
        }
        Path basePath = packMeta.getPath().resolve(packMeta.getNormalizedSubPath(subPath));
        ArrayList<Category> categories = new ArrayList<Category>();
        boolean hasBlueprints = false;
        try (Stream<Path> paths = Files.list(basePath);){
            for (Path file : paths.toList()) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    Category newCategory = new Category(packMeta, file, false, true, false);
                    try (Stream<Path> subPaths = Files.list(file);){
                        subPaths.forEach(subFile -> {
                            if (subFile.endsWith("icon.png")) {
                                newCategory.hasIcon = true;
                            } else if (Files.isDirectory(subFile, new LinkOption[0])) {
                                newCategory.isTerminal = false;
                            }
                        });
                        categories.add(newCategory);
                    }
                    catch (IOException e) {
                        Log.getLogger().error("Error loading category: " + String.valueOf(file), (Throwable)e);
                    }
                    continue;
                }
                if (!file.toString().endsWith(".blueprint")) continue;
                hasBlueprints = true;
            }
        }
        catch (IOException e) {
            Log.getLogger().error("Error loading categories from folder: " + packMeta.getNormalizedSubPath(subPath), (Throwable)e);
        }
        if (hasBlueprints && !categories.isEmpty()) {
            categories.add(new Category(packMeta, basePath, false, true, true));
        }
        categories.sort(Comparator.comparing(Category::toString));
        return categories;
    }

    public static void discoverPackAtPath(Path element, boolean immutable, List<String> modList, boolean clientPack, String owner) {
        block15: {
            Path packJsonPath = element.resolve("pack.json");
            if (Files.exists(packJsonPath, new LinkOption[0])) {
                try {
                    try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(packJsonPath));){
                        StructurePackMeta pack = new StructurePackMeta(Streams.parse((JsonReader)reader).getAsJsonObject(), element, owner);
                        if (pack.getPackFormat() == 1) {
                            pack.setImmutable(immutable);
                            for (String modId : pack.getModList()) {
                                if (modList.contains(modId)) continue;
                                Log.getLogger().warn("Missing Mod: " + modId + " for Pack: " + pack.getName());
                                return;
                            }
                            if (clientPack) {
                                clientPackMetas.put(pack.getName(), pack);
                            } else {
                                packMetas.put(pack.getName(), pack);
                            }
                            Log.getLogger().info("Registered structure pack: " + pack.getName());
                            break block15;
                        }
                        Log.getLogger().warn("Wrong Pack Format: " + pack.getName());
                    }
                    catch (IOException ex) {
                        Log.getLogger().warn("Error Reading pack: ", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Error Reading Json: " + String.valueOf(element), (Throwable)ex);
                }
            }
        }
    }

    public static Future<Blueprint> storeBlueprint(String packName, CompoundTag compoundTag, Path path, HolderLookup.Provider provider) {
        return IOPool.submit(() -> {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedOutputStream outputstream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                NbtIo.writeCompressed((CompoundTag)compoundTag, (OutputStream)outputstream);
            }
            catch (IOException e) {
                Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
                return null;
            }
            return StructurePacks.getBlueprint(packName, path, provider);
        });
    }

    public static boolean hasPack(String key) {
        return packMetas.containsKey(key);
    }

    public static class Category {
        public StructurePackMeta packMeta;
        public String subPath;
        public boolean hasIcon;
        public boolean isTerminal;
        public boolean isCurrent;

        public Category() {
        }

        public Category(StructurePackMeta packMeta, Path subPath, boolean hasIcon, boolean isTerminal, boolean isCurrent) {
            this.packMeta = packMeta;
            this.subPath = packMeta.getSubPath(subPath).replace("\\", "/");
            this.hasIcon = hasIcon;
            this.isTerminal = isTerminal;
            this.isCurrent = isCurrent;
            if (this.subPath.endsWith("/")) {
                this.subPath = this.subPath.substring(0, this.subPath.length() - 1);
            }
            if (this.subPath.startsWith("/")) {
                this.subPath = this.subPath.substring(1);
            }
            if (this.isCurrent) {
                this.subPath = this.subPath + "/.";
            }
        }

        public String toString() {
            return this.subPath;
        }
    }
}

