/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.util.ScanToolData;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdateScanToolMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"update_scan_tool", UpdateScanToolMessage::new);
    private final ScanToolData data;

    protected UpdateScanToolMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.data = (ScanToolData)ScanToolData.STREAM_CODEC.decode((Object)buf);
    }

    public UpdateScanToolMessage(ScanToolData data) {
        super(TYPE);
        this.data = data;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        ScanToolData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof ItemScanTool) {
            ItemScanTool tool = (ItemScanTool)item;
            tool.loadSlot(ScanToolData.updateItemStack(stack, old -> this.data), stack);
        }
    }
}

