/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.util.ScanToolData;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ScanOnServerMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"scan_on_server", ScanOnServerMessage::new);
    private final ScanToolData.Slot slot;
    private final boolean saveEntities;

    protected ScanOnServerMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.slot = (ScanToolData.Slot)ScanToolData.Slot.STREAM_CODEC.decode((Object)buf);
        this.saveEntities = buf.readBoolean();
    }

    public ScanOnServerMessage(ScanToolData.Slot slot, boolean saveEntities) {
        super(TYPE);
        this.slot = slot;
        this.saveEntities = saveEntities;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        ScanToolData.Slot.STREAM_CODEC.encode((Object)buf, (Object)this.slot);
        buf.writeBoolean(this.saveEntities);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        ItemScanTool.saveStructure(player.getCommandSenderWorld(), (Player)player, this.slot, this.saveEntities);
    }
}

