/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OperationHistoryMessage
extends AbstractPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forBothSides((String)"structurize", (String)"operation_history", OperationHistoryMessage::new);
    private final List<Tuple<String, Integer>> operationIDs;

    protected OperationHistoryMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.operationIDs = buf.readList(b -> new Tuple((Object)b.readUtf(), (Object)b.readInt()));
    }

    public OperationHistoryMessage() {
        super(TYPE);
        this.operationIDs = new ArrayList<Tuple<String, Integer>>();
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeCollection(this.operationIDs, (b, operation) -> {
            b.writeUtf((String)operation.getA());
            b.writeInt(((Integer)operation.getB()).intValue());
        });
    }

    protected void onClientExecute(IPayloadContext context, Player player) {
        WindowUndoRedo.lastOperations = this.operationIDs;
    }

    protected void onServerExecute(IPayloadContext context, ServerPlayer player) {
        List<ChangeStorage> operations = Manager.getChangeStoragesForPlayer(player.getUUID());
        for (ChangeStorage storage : operations) {
            this.operationIDs.add((Tuple<String, Integer>)new Tuple((Object)storage.getOperation().getString(), (Object)storage.getID()));
        }
        this.sendToPlayer(player);
    }
}

