/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.config;

import com.ldtteam.common.config.AbstractConfiguration;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfiguration
extends AbstractConfiguration {
    public final ModConfigSpec.BooleanValue ignoreSchematicsFromJar;
    public final ModConfigSpec.BooleanValue allowPlayerSchematics;
    public final ModConfigSpec.IntValue maxOperationsPerTick;
    public final ModConfigSpec.IntValue maxCachedChanges;
    public final ModConfigSpec.IntValue maxCachedSchematics;
    public final ModConfigSpec.IntValue maxBlocksChecked;
    public final ModConfigSpec.IntValue schematicBlockLimit;
    public final ModConfigSpec.ConfigValue<String> iteratorType;
    public final ModConfigSpec.BooleanValue teleportAllowed;
    public final ModConfigSpec.EnumValue<Direction> teleportBuildDirection;
    public final ModConfigSpec.IntValue teleportBuildDistance;
    public final ModConfigSpec.BooleanValue teleportSafety;

    public ServerConfiguration(ModConfigSpec.Builder builder) {
        super(builder, "structurize");
        this.createCategory("gameplay");
        this.ignoreSchematicsFromJar = this.defineBoolean("ignoreSchematicsFromJar", false);
        this.allowPlayerSchematics = this.defineBoolean("allowPlayerSchematics", true);
        this.maxOperationsPerTick = this.defineInteger("maxOperationsPerTick", 1000, 0, 100000);
        this.maxCachedChanges = this.defineInteger("maxCachedChanges", 50, 0, 250);
        this.maxCachedSchematics = this.defineInteger("maxCachedSchematics", 100, 0, 100000);
        this.maxBlocksChecked = this.defineInteger("maxBlocksChecked", 1000, 0, 100000);
        this.schematicBlockLimit = this.defineInteger("schematicBlockLimit", 100000, 1000, 1000000);
        this.iteratorType = this.defineString("iteratorType", "default");
        this.swapToCategory("teleport");
        this.teleportAllowed = this.defineBoolean("teleportAllowed", true);
        this.teleportBuildDirection = this.defineEnum("teleportBuildDirection", (Enum)Direction.SOUTH);
        this.teleportBuildDistance = this.defineInteger("teleportBuildDistance", 3, 1, 16);
        this.teleportSafety = this.defineBoolean("teleportSafety", true);
        this.finishCategory();
    }
}

