/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.config;

import com.ldtteam.common.config.AbstractConfiguration;
import com.ldtteam.structurize.client.BlueprintHandler;
import com.ldtteam.structurize.network.messages.SyncSettingsToServer;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfiguration
extends AbstractConfiguration {
    public final ModConfigSpec.BooleanValue renderPlaceholdersNice;
    public final ModConfigSpec.BooleanValue sharePreviews;
    public final ModConfigSpec.BooleanValue displayShared;
    public final ModConfigSpec.IntValue rendererLightLevel;
    public final ModConfigSpec.DoubleValue rendererTransparency;
    public final ModConfigSpec.BooleanValue scanToolScrolling;

    public ClientConfiguration(ModConfigSpec.Builder builder) {
        super(builder, "structurize");
        this.createCategory("blueprint");
        this.createCategory("renderer");
        this.renderPlaceholdersNice = this.defineBoolean("render_placeholders_nice", false);
        this.sharePreviews = this.defineBoolean("share_previews", false);
        this.displayShared = this.defineBoolean("see_shared_previews", false);
        this.rendererLightLevel = this.defineInteger("light_level", 15, -1, 15);
        this.rendererTransparency = this.defineDouble("transparency", -1.0, -1.0, 1.0);
        this.addWatcher(BlueprintHandler.getInstance()::clearCache, new ModConfigSpec.ConfigValue[]{this.renderPlaceholdersNice, this.rendererLightLevel});
        this.addWatcher((ModConfigSpec.ConfigValue)this.displayShared, (oldValue, isSharingEnabled) -> {
            new SyncSettingsToServer().sendToServer();
            if (!isSharingEnabled.booleanValue()) {
                RenderingCache.removeSharedPreviews();
            }
        });
        this.addWatcher((ModConfigSpec.ConfigValue)this.sharePreviews, (oldVal, shouldSharePreviews) -> {
            if (shouldSharePreviews.booleanValue()) {
                RenderingCache.getBlueprintsToRender().forEach(BlueprintPreviewData::syncChangesToServer);
            }
        });
        this.finishCategory();
        this.finishCategory();
        this.createCategory("gameplay");
        this.scanToolScrolling = this.defineBoolean("scan_tool_scrolling", true);
        this.finishCategory();
    }

    public void collectPreviewRendererSettings(MessagePassingQueue.Consumer<ModConfigSpec.ConfigValue<?>> sink) {
        sink.accept((Object)this.sharePreviews);
        sink.accept((Object)this.displayShared);
        sink.accept((Object)this.renderPlaceholdersNice);
        sink.accept((Object)this.rendererLightLevel);
        sink.accept((Object)this.rendererTransparency);
    }
}

