/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blocks.interfaces.ISpecialCreativeHandlerAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.PlaceStructureOperation;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.server.command.EnumArgument;
import org.jetbrains.annotations.Nullable;

public class PasteCommand
extends AbstractCommand {
    public static final String commandName = "paste";
    private static final String PLAYER_NOT_FOUND = "com.structurize.command.playernotfound";
    private static final String PASTE_SUCCESS_MESSAGE = "com.structurize.command.paste.success";
    private static final String NO_PERMISSION_MESSAGE = "com.structurize.command.paste.no.perm";
    private static final String NO_PACK_MESSAGE = "com.structurize.command.paste.no.pack";
    private static final String NO_BLUEPRINT_MESSAGE = "com.structurize.command.paste.no.blueprint";
    private static final String PLAYER_NAME = "player";
    private static final String POS = "pos";
    private static final String PACK_NAME = "pack";
    private static final String FILE_PATH = "path";
    private static final String ROT_MIR = "rotation_mirror";
    private static final String PRETTY = "pretty";

    private static int execute(CommandSourceStack source, BlockPos pos, String pack, String tempPath, RotationMirror rotMir, boolean pretty, Player player) throws CommandSyntaxException {
        AbstractStructureHandler structure;
        @Nullable ServerLevel world = source.getLevel();
        if (source.getEntity() instanceof Player && !source.getPlayerOrException().isCreative()) {
            source.sendFailure((Component)Component.literal((String)NO_PERMISSION_MESSAGE));
            return 0;
        }
        if (!(player instanceof ServerPlayer)) {
            source.sendFailure((Component)Component.translatable((String)PLAYER_NOT_FOUND));
            return 0;
        }
        String[] split = tempPath.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (String string : split) {
            if (!builder.toString().isEmpty()) {
                builder.append("/");
            }
            builder.append(string);
        }
        String path = builder.toString();
        String[] packSplit = pack.split("\\.");
        StringBuilder packBuilder = new StringBuilder();
        for (String part : packSplit) {
            if (!packBuilder.toString().isEmpty()) {
                packBuilder.append(" ");
            }
            packBuilder.append(part);
        }
        String string = packBuilder.toString();
        if (!StructurePacks.hasPack(string)) {
            source.sendFailure((Component)Component.translatable((String)NO_PACK_MESSAGE));
            return 0;
        }
        Blueprint blueprint = StructurePacks.getBlueprint(string, path + ".blueprint", true, (HolderLookup.Provider)source.registryAccess());
        if (blueprint == null) {
            source.sendFailure((Component)Component.translatable((String)NO_BLUEPRINT_MESSAGE));
            return 0;
        }
        BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        blueprint.setRotationMirror(rotMir, (Level)world);
        Block block = anchor.getBlock();
        if (block instanceof ISpecialCreativeHandlerAnchorBlock) {
            ISpecialCreativeHandlerAnchorBlock specialAnchor = (ISpecialCreativeHandlerAnchorBlock)block;
            if (!specialAnchor.setup((ServerPlayer)player, (Level)world, pos, blueprint, rotMir, pretty, string, path)) {
                return 0;
            }
            structure = specialAnchor.getStructureHandler((Level)world, pos, blueprint, rotMir, pretty);
        } else {
            structure = new CreativeStructureHandler((Level)world, pos, blueprint, rotMir, pretty);
        }
        StructurePlacer instantPlacer = new StructurePlacer(structure);
        Manager.addToQueue(new PlaceStructureOperation(instantPlacer, player));
        source.sendSuccess(() -> Component.translatable((String)PASTE_SUCCESS_MESSAGE), true);
        return 1;
    }

    private static int onExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, RotationMirror.NONE, true, (Player)((CommandSourceStack)context.getSource()).getPlayer());
    }

    private static int onExecuteWithRotationAndMirror(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        RotationMirror rotMir = (RotationMirror)((Object)context.getArgument(ROT_MIR, RotationMirror.class));
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotMir, true, (Player)((CommandSourceStack)context.getSource()).getPlayer());
    }

    private static int onExecuteWithFull(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        RotationMirror rotMir = (RotationMirror)((Object)context.getArgument(ROT_MIR, RotationMirror.class));
        boolean pretty = BoolArgumentType.getBool(context, (String)PRETTY);
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotMir, pretty, (Player)((CommandSourceStack)context.getSource()).getPlayer());
    }

    private static int onExecuteWithFullAndPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        RotationMirror rotMir = (RotationMirror)((Object)context.getArgument(ROT_MIR, RotationMirror.class));
        boolean pretty = BoolArgumentType.getBool(context, (String)PRETTY);
        GameProfile profile = GameProfileArgument.getGameProfiles(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        if (profile == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)PLAYER_NOT_FOUND));
            return 0;
        }
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotMir, pretty, (Player)((CommandSourceStack)context.getSource()).getLevel().getServer().getPlayerList().getPlayer(profile.getId()));
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)PasteCommand.newLiteral(commandName).then(PasteCommand.newArgument(POS, BlockPosArgument.blockPos()).then(PasteCommand.newArgument(PACK_NAME, StringArgumentType.string()).then(((RequiredArgumentBuilder)PasteCommand.newArgument(FILE_PATH, StringArgumentType.string()).executes(PasteCommand::onExecute)).then(((RequiredArgumentBuilder)PasteCommand.newArgument(ROT_MIR, EnumArgument.enumArgument(RotationMirror.class)).executes(PasteCommand::onExecuteWithRotationAndMirror)).then(((RequiredArgumentBuilder)PasteCommand.newArgument(PRETTY, BoolArgumentType.bool()).executes(PasteCommand::onExecuteWithFull)).then(PasteCommand.newArgument(PLAYER_NAME, GameProfileArgument.gameProfile()).executes(PasteCommand::onExecuteWithFullAndPlayer)))))));
    }
}

