/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.upgrades.BaseUpgradeEffect;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.slots.SlotCart;
import vswe.stevescarts.containers.slots.SlotModule;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.init.ModItemData;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.upgrades.InventoryUpgradeEffect;

public class Disassemble
extends InventoryUpgradeEffect {
    @Override
    public int getInventorySize() {
        return 31;
    }

    @Override
    public int getSlotX(int id) {
        if (id == 0) {
            return 178;
        }
        return 38 + (id - 1) % 10 * 18;
    }

    @Override
    public int getSlotY(int id) {
        int y = id == 0 ? 0 : (id - 1) / 10 + 2;
        return 8 + y * 18;
    }

    @Override
    public Class<? extends Slot> getSlot(int i) {
        if (i == 0) {
            return SlotCart.class;
        }
        return SlotModule.class;
    }

    @Override
    public void load(TileEntityUpgrade upgrade, CompoundTag compound, HolderLookup.Provider provider) {
        this.setLastCart(upgrade, upgrade.getItem(0));
    }

    @Override
    public String getName() {
        return "info.stevescarts.effectDisassemble";
    }

    @Override
    public void onInventoryChanged(TileEntityUpgrade upgrade) {
        ItemStack cart = upgrade.getItem(0);
        if (!this.updateCart(upgrade, cart)) {
            boolean needsToPuke = true;
            for (int i = 1; i < this.getInventorySize(); ++i) {
                if (!upgrade.getItem(i).isEmpty()) continue;
                ItemStack item = upgrade.getItem(0);
                upgrade.setItem(0, ItemStack.EMPTY);
                upgrade.setItem(i, item);
                needsToPuke = false;
                break;
            }
            if (needsToPuke) {
                if (!upgrade.getLevel().isClientSide) {
                    upgrade.getMaster().puke(upgrade.getItem(0).copy());
                }
                upgrade.setItem(0, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public void removed(TileEntityUpgrade upgrade) {
        this.updateCart(upgrade, ItemStack.EMPTY);
    }

    private void resetMaster(TileEntityCartAssembler master, boolean full) {
        for (int i = 0; i < master.getContainerSize() - master.nonModularSlots(); ++i) {
            if (master.getItem(i).isEmpty()) continue;
            if (TileEntityCartAssembler.getSlotStatus(master.getItem(i)) <= 0) {
                master.setItem(i, ItemStack.EMPTY);
                continue;
            }
            if (!full) continue;
            if (!master.getLevel().isClientSide) {
                master.puke(master.getItem(i).copy());
            }
            master.setItem(i, ItemStack.EMPTY);
        }
    }

    private void setLastCart(TileEntityUpgrade upgrade, ItemStack cart) {
        if (!cart.isEmpty()) {
            cart.save((HolderLookup.Provider)upgrade.getLevel().registryAccess(), (Tag)upgrade.getCompound());
        }
    }

    private ItemStack getLastCart(TileEntityUpgrade upgrade) {
        return ItemStack.parseOptional((HolderLookup.Provider)upgrade.getLevel().registryAccess(), (CompoundTag)upgrade.getCompound());
    }

    private boolean updateCart(TileEntityUpgrade upgrade, ItemStack cart) {
        if (upgrade.getMaster() != null) {
            if (cart.isEmpty() || cart.getItem() != ModItems.CARTS.get() || ModItemData.getTagCopy(cart).contains("maxTime")) {
                this.resetMaster(upgrade.getMaster(), false);
                this.setLastCart(upgrade, ItemStack.EMPTY);
                if (!cart.isEmpty()) {
                    upgrade.getMaster().puke(cart);
                    upgrade.setItem(0, ItemStack.EMPTY);
                }
            } else {
                ItemStack last = this.getLastCart(upgrade);
                this.setLastCart(upgrade, cart);
                int result = this.canDisassemble(upgrade);
                boolean reset = false;
                if (result > 0 && !last.isEmpty() && !ItemStack.isSameItem((ItemStack)cart, (ItemStack)last)) {
                    result = 2;
                    reset = true;
                }
                if (result != 2) {
                    return result == 1 && !upgrade.getMaster().getItem(0).isEmpty();
                }
                if (reset) {
                    this.resetMaster(upgrade.getMaster(), true);
                }
                boolean addedHull = false;
                NonNullList<ItemStack> modules = ModuleData.getModularItems(cart);
                for (ItemStack item : modules) {
                    ModItemData.modifyTag(item, tag -> tag.putInt("ModifyStatus", 0));
                    TransferHandler.TransferItem(item, (Container)upgrade.getMaster(), new ContainerCartAssembler(0, null, upgrade.getMaster(), new SimpleContainerData(0)), 1);
                    if (addedHull) continue;
                    addedHull = true;
                    upgrade.getMaster().updateSlots();
                }
            }
        }
        return true;
    }

    public int canDisassemble(TileEntityUpgrade upgrade) {
        int i;
        int disassembleCount = 0;
        for (BaseUpgradeEffect effect : upgrade.getMaster().getEffects()) {
            if (!(effect instanceof Disassemble)) continue;
            ++disassembleCount;
        }
        if (disassembleCount != 1) {
            return 0;
        }
        for (i = 0; i < upgrade.getMaster().getContainerSize() - upgrade.getMaster().nonModularSlots(); ++i) {
            if (upgrade.getMaster().getItem(i).isEmpty() || TileEntityCartAssembler.getSlotStatus(upgrade.getMaster().getItem(i)) > 0) continue;
            return 1;
        }
        for (i = 0; i < upgrade.getMaster().getContainerSize() - upgrade.getMaster().nonModularSlots(); ++i) {
            if (upgrade.getMaster().getItem(i).isEmpty()) continue;
            return 0;
        }
        return 2;
    }
}

