/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tracks;

import net.minecraft.sounds.SoundEvents;
import vswe.stevescarts.arcade.ArcadeGame;
import vswe.stevescarts.arcade.tracks.ArcadeTracks;
import vswe.stevescarts.arcade.tracks.Cart;
import vswe.stevescarts.arcade.tracks.Track;
import vswe.stevescarts.arcade.tracks.TrackOrientation;

public class TrackEnderHandler
extends Track {
    private boolean isSpawner;

    public TrackEnderHandler(int x, int y, TrackOrientation orientation, boolean isSpawner) {
        super(x, y, orientation);
        this.isSpawner = isSpawner;
    }

    @Override
    public void travel(ArcadeTracks game, Cart cart) {
        if (this.isSpawner) {
            game.getEnderman().setAlive(true);
            game.getEnderman().setDirection(TrackOrientation.DIRECTION.RIGHT);
            game.getEnderman().setX(cart.getX() + 5);
            game.getEnderman().setY(cart.getY());
        } else if (game.getEnderman().isAlive()) {
            game.getEnderman().setAlive(false);
        }
        ArcadeGame.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
    }

    @Override
    public Track copy() {
        return new TrackEnderHandler(this.getX(), this.getY(), this.getOrientation(), this.isSpawner);
    }
}

