/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tracks;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import vswe.stevescarts.arcade.tracks.ArcadeTracks;
import vswe.stevescarts.arcade.tracks.Cart;
import vswe.stevescarts.arcade.tracks.Track;
import vswe.stevescarts.arcade.tracks.TrackOrientation;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.modules.realtimers.ModuleArcade;

public class TrackDetector
extends Track {
    private ArrayList<TrackCoordinate> targets = new ArrayList();

    public TrackDetector(int x, int y, TrackOrientation orientation) {
        super(x, y, orientation);
    }

    @Override
    public Track copy() {
        TrackDetector newTrack = new TrackDetector(this.getX(), this.getY(), this.getOrientation());
        newTrack.targets = this.targets;
        return newTrack;
    }

    public TrackDetector addTarget(int x, int y) {
        if ((int)Math.ceil((float)this.targets.size() * 1.125f) == 63) {
            return this;
        }
        for (int i = 0; i < this.targets.size(); ++i) {
            if (this.targets.get(i).getX() != x || this.targets.get(i).getY() != y) continue;
            this.targets.remove(i);
            return this;
        }
        this.targets.add(new TrackCoordinate(x, y));
        return this;
    }

    @Override
    public void setExtraInfo(byte[] data) {
        int startPosition = 0;
        short content = 0;
        for (int i = 0; i < data.length; ++i) {
            short val = data[i];
            if (val < 0) {
                val = (short)(val + 256);
            }
            content = (short)(content | (short)((val & (int)Math.pow(2.0, Math.min(8, 9 - startPosition)) - 1) << startPosition));
            if (startPosition == 0) {
                startPosition = 8;
                continue;
            }
            this.addTarget(content & 0x1F, (content & 0x1E0) >> 5);
            content = (short)((val & (int)Math.pow(2.0, startPosition - 1) - 1 << 9 - startPosition) >> 9 - startPosition);
            startPosition = (startPosition + 8) % 9;
        }
    }

    @Override
    public byte[] getExtraInfo() {
        byte[] ret = new byte[(int)Math.ceil((float)this.targets.size() * 1.125f)];
        int currentByte = 0;
        int startPosition = 0;
        for (int i = 0; i < this.targets.size(); ++i) {
            int n;
            short data = (short)this.targets.get(i).getX();
            data = (short)(data | (short)(this.targets.get(i).getY() << 5));
            byte[] array = ret;
            int n2 = n = currentByte++;
            array[n2] = (byte)(array[n2] | (byte)((data & (int)Math.pow(2.0, 8 - startPosition) - 1) << startPosition));
            ret[currentByte] = (byte)((data & (int)Math.pow(2.0, 1 + startPosition) - 1 << 8 - startPosition) >> 8 - startPosition);
            if ((startPosition = (startPosition + 1) % 8) != 0) continue;
            ++currentByte;
        }
        return ret;
    }

    @Override
    public int getU() {
        return 1;
    }

    @Override
    public void travel(ArcadeTracks game, Cart cart) {
        for (TrackCoordinate target : this.targets) {
            Track track = game.getTrackMap()[target.getX()][target.getY()];
            if (track == null) continue;
            track.flip();
        }
    }

    @Override
    public void drawOverlay(GuiGraphics guiGraphics, ModuleArcade module, GuiMinecart gui, int x, int y, boolean isRunning) {
        if (!isRunning && module.inRect(x, y, ArcadeTracks.getTrackArea(this.getX(), this.getY()))) {
            for (TrackCoordinate target : this.targets) {
                module.drawImage(guiGraphics, gui, ArcadeTracks.getTrackArea(target.getX(), target.getY()), 0, 128);
            }
        }
    }

    @Override
    public void onEditorClick(ArcadeTracks game) {
        game.setEditorDetectorTrack(this);
    }

    private static class TrackCoordinate {
        private int x;
        private int y;

        public TrackCoordinate(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

