/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.monopoly;

import java.util.EnumSet;
import net.minecraft.client.gui.GuiGraphics;
import vswe.stevescarts.arcade.monopoly.ArcadeMonopoly;
import vswe.stevescarts.arcade.monopoly.Piece;
import vswe.stevescarts.arcade.monopoly.Place;
import vswe.stevescarts.arcade.monopoly.Property;
import vswe.stevescarts.arcade.monopoly.StreetGroup;
import vswe.stevescarts.client.guis.GuiMinecart;

public class Street
extends Property {
    private float[] color;
    private int structures;
    private int baseRent;

    public Street(ArcadeMonopoly game, StreetGroup group, String name, int cost, int baseRent) {
        super(game, group, name, cost);
        this.color = group.getColor();
        this.baseRent = baseRent;
    }

    @Override
    public void draw(GuiGraphics guiGraphics, GuiMinecart gui, EnumSet<Place.PLACE_STATE> states) {
        super.draw(guiGraphics, gui, states);
        this.game.getModule().drawImage(guiGraphics, gui, 0, 0, 76, 0, 76, 22);
        if (this.structures > 0 && this.structures < 5) {
            for (int i = 0; i < this.structures; ++i) {
                this.game.getModule().drawImage(guiGraphics, gui, 3 + i * 18, 3, 76, 22, 16, 16);
            }
        } else if (this.structures == 5) {
            this.game.getModule().drawImage(guiGraphics, gui, 3, 3, 92, 22, 16, 16);
        }
        this.drawValue(guiGraphics, gui);
    }

    public void increaseStructure() {
        ++this.structures;
    }

    @Override
    protected int getTextY() {
        return 30;
    }

    public int getRentCost(int structureCount) {
        switch (structureCount) {
            default: {
                return this.baseRent;
            }
            case 1: {
                return this.baseRent * 5;
            }
            case 2: {
                return this.baseRent * 15;
            }
            case 3: {
                return this.baseRent * 40;
            }
            case 4: {
                return this.baseRent * 70;
            }
            case 5: 
        }
        return this.baseRent * 100;
    }

    public int getRentCost(boolean ownsAll) {
        if (ownsAll) {
            return this.baseRent * 2;
        }
        return this.baseRent;
    }

    @Override
    public int getRentCost() {
        if (this.structures == 0) {
            return this.getRentCost(this.ownsAllInGroup(this.getOwner()));
        }
        return this.getRentCost(this.structures);
    }

    public int getStructureCount() {
        return this.structures;
    }

    public int getStructureCost() {
        return ((StreetGroup)this.getGroup()).getStructureCost();
    }

    public boolean ownsAllInGroup(Piece currentPiece) {
        for (Property property : this.getGroup().getProperties()) {
            if (property.getOwner() == currentPiece && !property.isMortgaged()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canMortgage() {
        return super.canMortgage() && this.structures == 0;
    }

    public int getStructureSellPrice() {
        return this.getStructureCost() / 2;
    }

    public void decreaseStructures() {
        --this.structures;
    }
}

