/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.starterstructure_common_forge.events.StructureCreationEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeStructureCreationEvents {
    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onLevelSpawn(LevelEvent.CreateSpawnPosition e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        if (StructureCreationEvents.onLevelSpawn((ServerLevel)level, (ServerLevelData)level.getLevelData()).equals((Object)InteractionResult.SUCCESS)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        StructureCreationEvents.onLevelLoad((ServerLevel)level);
    }
}

