/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.item;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.util.ItemUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class RRobinItemTransport
extends StarbyTransportBehavior {
    public static final ResourceLocation TRANSPORT_ID = ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"starby_robin_item_transport");
    private final Map<Item, Integer> itemRoundRobinIndex = new HashMap<Item, Integer>();

    public RRobinItemTransport(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
    }

    public ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public boolean isPickupDisabled() {
        return true;
    }

    public BlockPos getValidStorePos(ItemStack stack) {
        return this.getValidStorePos(stack, true);
    }

    public BlockPos getValidStorePos(ItemStack stack, boolean advanceIndex) {
        if (this.TO_LIST.isEmpty() || stack.isEmpty()) {
            return null;
        }
        BlockPos returnPos = null;
        Item item = stack.getItem();
        int size = this.TO_LIST.size();
        int startIndex = this.itemRoundRobinIndex.getOrDefault(item, 0);
        ItemScroll.SortPref foundPref = ItemScroll.SortPref.INVALID;
        int winningIndex = -1;
        for (int i = 0; i < size; ++i) {
            int index = (startIndex + i) % size;
            BlockPos b = (BlockPos)this.TO_LIST.get(index);
            ItemScroll.SortPref pref = this.sortPrefForStack(b, stack);
            if (pref.ordinal() <= foundPref.ordinal()) continue;
            foundPref = pref;
            returnPos = b;
            winningIndex = index;
            if (foundPref == ItemScroll.SortPref.HIGHEST) break;
        }
        if (advanceIndex && returnPos != null) {
            this.itemRoundRobinIndex.put(item, (winningIndex + 1) % size);
        }
        return returnPos;
    }

    public int getMaxTake(ItemStack stack) {
        BlockPos validStorePos = this.getValidStorePos(stack, false);
        if (validStorePos == null) {
            return -1;
        }
        IItemHandler handler = this.getItemCapFromTile(validStorePos, (Direction)this.FROM_DIRECTION_MAP.get(validStorePos.hashCode()));
        if (handler == null) {
            return -1;
        }
        try {
            int maxEvenTake = Math.ceilDiv(stack.getMaxStackSize(), this.TO_LIST.size());
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack simStack;
                int originalCount;
                int maxRoom;
                ItemStack handlerStack = handler.getStackInSlot(i);
                if (handlerStack.isEmpty()) {
                    return Math.clamp((long)handler.getSlotLimit(i), 1, maxEvenTake);
                }
                if (!ItemUtil.canStack((ItemStack)handlerStack, (ItemStack)stack) || (maxRoom = (originalCount = stack.getCount()) - (simStack = handler.insertItem(i, stack, true)).getCount()) <= 0) continue;
                return Math.min(maxRoom, Math.clamp((long)handler.getSlotLimit(i), 1, maxEvenTake));
            }
        }
        catch (Exception e) {
            System.out.println("Error while getting max take" + String.valueOf(e));
        }
        return -1;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null || !this.level.isLoaded(p)) {
            return false;
        }
        Direction face = (Direction)this.FROM_DIRECTION_MAP.get(p.hashCode());
        IItemHandler iItemHandler = this.getItemCapFromTile(p, face);
        if (iItemHandler == null) {
            return false;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.isEmpty() || this.getValidStorePos(stack, false) == null) continue;
            return true;
        }
        return false;
    }

    public boolean canGoToBed() {
        return this.isBedPowered() || this.getValidTakePos() == null && (this.starbuncle.getHeldStack().isEmpty() || this.getValidStorePos(this.starbuncle.getHeldStack(), false) == null);
    }
}

