/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.fluid;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.common.block.fluids.LiquidJarTile;
import alexthw.starbunclemania.common.item.FluidScroll;
import alexthw.starbunclemania.registry.ModRegistry;
import alexthw.starbunclemania.starbuncle.StarHelper;
import alexthw.starbunclemania.starbuncle.fluid.FluidExtractGoal;
import alexthw.starbunclemania.starbuncle.fluid.FluidStoreGoal;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarbyFluidBehavior
extends StarbyListBehavior {
    public static final ResourceLocation TRANSPORT_ID = ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"starby_fluid_transport");
    @NotNull
    private FluidStack fluidStack = FluidStack.EMPTY;
    public ItemStack fluidScroll;

    public StarbyFluidBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.contains("fluid")) {
            this.fluidStack = FluidStack.parseOptional((HolderLookup.Provider)entity.level().registryAccess(), (CompoundTag)tag.getCompound("fluid"));
        }
        if (tag.contains("fluidScroll")) {
            this.fluidScroll = ItemStack.parseOptional((HolderLookup.Provider)entity.level().registryAccess(), (CompoundTag)tag.getCompound("fluidScroll"));
        }
        this.goals.add(new WrappedGoal(3, (Goal)new FluidStoreGoal(entity, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new FluidExtractGoal(entity, this)));
    }

    public boolean canGoToBed() {
        return this.isBedPowered() || this.getTankToExtract() == null && (this.getFluidStack().isEmpty() || this.getTankForStorage() == null);
    }

    @NotNull
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public void setFluidStack(FluidStack fluid) {
        this.fluidStack = fluid;
        this.syncTag();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && this.level.getCapability(Capabilities.FluidHandler.BLOCK, storedPos, (Object)side) != null) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.fluid_to"));
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && this.level.getCapability(Capabilities.FluidHandler.BLOCK, storedPos, (Object)side) != null) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.fluid_from"));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof FluidScroll && !stack.isComponentsPatchEmpty()) {
            this.fluidScroll = stack;
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.filter_set"));
            this.syncTag();
        }
        return super.mobInteract(player, hand);
    }

    public void getTooltip(Consumer<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.storing_fluid", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.taking_fluid", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (!this.fluidStack.isEmpty()) {
            LiquidJarTile.displayFluidTooltip(tooltip, this.getFluidStack());
        }
        if (this.fluidScroll != null && !this.fluidScroll.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)"ars_nouveau.filtering_with", (Object[])new Object[]{this.fluidScroll.getHoverName().getString()}));
        }
    }

    public int getRatio() {
        return (Integer)Configs.STARBUCKET_RATIO.get();
    }

    public ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public BlockPos getTankForStorage(FluidStack fluidInTank) {
        if (!fluidInTank.isEmpty()) {
            for (BlockPos pos : this.TO_LIST) {
                if (!this.level.isLoaded(pos) || !this.canStore(pos, fluidInTank)) continue;
                return pos;
            }
        }
        return null;
    }

    public BlockPos getTankForStorage() {
        return this.getTankForStorage(this.getFluidStack());
    }

    public BlockPos getTankToExtract() {
        for (BlockPos pos : this.FROM_LIST) {
            if (!this.level.isLoaded(pos) || !this.canExtract(pos)) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getHandlerFromCap(BlockPos pos, Level level, Direction sideOrdinal) {
        if (sideOrdinal == null) {
            sideOrdinal = Direction.UP;
        }
        sideOrdinal = StarHelper.checkItemFramesForSide(pos, level, sideOrdinal);
        return (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)sideOrdinal);
    }

    public IFluidHandler getHandlerFromCap(BlockPos pos, Direction side) {
        return StarbyFluidBehavior.getHandlerFromCap(pos, this.level, side);
    }

    public boolean canStore(BlockPos pos, @NotNull FluidStack fluidStack) {
        IFluidHandler fluid = this.getHandlerFromCap(pos, (Direction)this.TO_DIRECTION_MAP.get(pos.hashCode()));
        if (fluid != null) {
            for (int i = 0; i < fluid.getTanks(); ++i) {
                if (!fluid.isFluidValid(i, fluidStack) || fluid.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) < (Integer)Configs.STARBUCKET_THRESHOLD.get()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canExtract(BlockPos pos) {
        IFluidHandler fluid = this.getHandlerFromCap(pos, (Direction)this.FROM_DIRECTION_MAP.get(pos.hashCode()));
        if (fluid != null) {
            for (int i = 0; i < fluid.getTanks(); ++i) {
                if (fluid.getFluidInTank(i).isEmpty()) continue;
                if (FluidScroll.checkForFilters(pos, this.fluidScroll, fluid.getFluidInTank(i), this.starbuncle.level())) {
                    return false;
                }
                if (this.getTankForStorage(fluid.getFluidInTank(i)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (!this.getFluidStack().isEmpty()) {
            tag.put("fluid", this.getFluidStack().save((HolderLookup.Provider)this.starbuncle.registryAccess()));
        }
        if (this.fluidScroll != null) {
            tag.put("itemScroll", this.fluidScroll.save((HolderLookup.Provider)this.starbuncle.registryAccess()));
        }
        return super.toTag(tag);
    }

    public ItemStack getStackForRender() {
        Object object;
        ItemStack instance = ((Block)ModRegistry.FLUID_JAR.get()).asItem().getDefaultInstance();
        if (!this.getFluidStack().isEmpty() && (object = instance.getCapability(Capabilities.FluidHandler.ITEM)) instanceof IFluidHandlerItem) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)object;
            float fakePercentage = (float)this.getFluidStack().getAmount() / (float)this.getRatio();
            fluidHandler.fill(this.fluidStack.copyWithAmount((int)((float)fluidHandler.getTankCapacity(0) * fakePercentage)), IFluidHandler.FluidAction.EXECUTE);
        }
        return instance;
    }
}

