/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.fluid;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidExtractGoal
extends GoToPosGoal<StarbyFluidBehavior> {
    public FluidExtractGoal(Starbuncle starbuncle, StarbyFluidBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> behavior.getFluidStack().isEmpty());
    }

    public boolean canUse() {
        boolean superCan = super.canUse();
        if (!superCan || ((StarbyFluidBehavior)this.behavior).FROM_LIST.isEmpty()) {
            return false;
        }
        if (this.getDestination() == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoTakeDestination", "No valid take destination"));
            this.starbuncle.setBackOff(5 + this.starbuncle.level().random.nextInt(20));
            return false;
        }
        if (((StarbyFluidBehavior)this.behavior).isBedPowered()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("BedPowered", "Bed Powered, cannot take"));
            return false;
        }
        return true;
    }

    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    @Nullable
    public BlockPos getDestination() {
        return ((StarbyFluidBehavior)this.behavior).getTankToExtract();
    }

    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyFluidBehavior)this.behavior).canExtract(pos);
    }

    public boolean onDestinationReached() {
        IFluidHandler fluidHandlerExtract = ((StarbyFluidBehavior)this.behavior).getHandlerFromCap(this.targetPos, (Direction)((StarbyFluidBehavior)this.behavior).FROM_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (fluidHandlerExtract != null) {
            for (int tankIndexE = 0; tankIndexE < fluidHandlerExtract.getTanks(); ++tankIndexE) {
                BlockPos pos;
                FluidStack testExtract = new FluidStack(fluidHandlerExtract.getFluidInTank(tankIndexE).getFluid(), ((StarbyFluidBehavior)this.behavior).getRatio());
                if (testExtract.isEmpty() || fluidHandlerExtract.drain(testExtract, IFluidHandler.FluidAction.SIMULATE).isEmpty() || (pos = ((StarbyFluidBehavior)this.behavior).getTankForStorage(testExtract)) == null) continue;
                IFluidHandler fluidHandlerStore = ((StarbyFluidBehavior)this.behavior).getHandlerFromCap(pos, (Direction)((StarbyFluidBehavior)this.behavior).TO_DIRECTION_MAP.get(pos.hashCode()));
                if (fluidHandlerStore != null) {
                    FluidStack extracted;
                    int maxRoom = -1;
                    for (int s = 0; s < fluidHandlerStore.getTanks() && (maxRoom = fluidHandlerStore.fill(testExtract, IFluidHandler.FluidAction.SIMULATE)) <= (Integer)Configs.STARBUCKET_THRESHOLD.get(); ++s) {
                    }
                    if (maxRoom <= (Integer)Configs.STARBUCKET_THRESHOLD.get() || (extracted = fluidHandlerExtract.drain(new FluidStack(testExtract.getFluid(), maxRoom), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
                    ((StarbyFluidBehavior)this.behavior).setFluidStack(extracted);
                    this.starbuncle.level().playSound(null, this.targetPos, SoundEvents.BUCKET_FILL, SoundSource.NEUTRAL, 0.2f, 1.3f);
                    break;
                }
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoHandler", "No fluid handler at " + String.valueOf(pos)));
            }
        } else {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoHandler", "No fluid handler at " + this.targetPos.toString()));
        }
        return true;
    }
}

