/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.jei;

import alexthw.starbunclemania.jei.StarPlugin;
import alexthw.starbunclemania.recipe.FluidSourcelinkRecipe;
import alexthw.starbunclemania.registry.ModRegistry;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidLinkRecipeCategory
implements IRecipeCategory<FluidSourcelinkRecipe> {
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    public final IDrawable background;
    public final IDrawable icon;
    static final ResourceLocation ARROW = ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"textures/jei/gui/gui_vanilla.png");

    public FluidLinkRecipeCategory(final IGuiHelper helper) {
        this.background = helper.createBlankDrawable(120, 32);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ModRegistry.FLUID_SOURCELINK.get()).asItem().getDefaultInstance());
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            @NotNull
            public IDrawableAnimated load(@NotNull Integer cookTime) {
                return helper.drawableBuilder(ARROW, 82, 128, 24, 32).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    @NotNull
    public RecipeType<FluidSourcelinkRecipe> getRecipeType() {
        return StarPlugin.FLUID_SOURCELINK;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Fluid Sourcelink conversion");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, FluidSourcelinkRecipe recipe, @NotNull IFocusGroup focuses) {
        ResourceLocation fluid_name = recipe.fluidType();
        try {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluid_name);
            builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).setFluidRenderer(1000L, false, 16, 24).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(fluid, 1000));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void draw(FluidSourcelinkRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)40);
        arrow.draw(guiGraphics, 25, 10);
        Font font = Minecraft.getInstance().font;
        double ratio = recipe.conversion_ratio() * 1000.0;
        guiGraphics.drawString(font, String.format("%.0f Source", ratio), 55, 12, 0, false);
    }
}

