/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.datagen;

import alexthw.starbunclemania.ArsNouveauRegistry;
import alexthw.starbunclemania.glyph.PickupFluidEffect;
import alexthw.starbunclemania.glyph.PlaceFluidEffect;
import alexthw.starbunclemania.registry.ModRegistry;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ApparatusPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ImbuementPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ArsProviders {
    static final String root = "starbunclemania";

    public static class StarPatchouliProvider
    extends PatchouliProvider {
        public StarPatchouliProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(generatorIn, lookupProvider);
        }

        public void collectJsons(CachedOutput cache) {
            for (AbstractSpellPart spell : ArsNouveauRegistry.registeredSpells) {
                this.addGlyphPage(spell);
            }
            this.addBasicItem((ItemLike)ModRegistry.FLUID_JAR.get(), AUTOMATION, (IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.FLUID_JAR.get()));
            this.addBasicItem((ItemLike)ModRegistry.SOURCE_CONDENSER.get(), SOURCE, (IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.SOURCE_CONDENSER.get()));
            this.addBasicItem((ItemLike)ModRegistry.FLUID_SOURCELINK.get(), SOURCE, (IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.FLUID_SOURCELINK.get()));
            this.addBasicItem((ItemLike)ModRegistry.DIRECTION_SCROLL.get(), AUTOMATION, (IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.DIRECTION_SCROLL.get()));
            this.addPage(new PatchouliBuilder(FAMILIARS, (ItemLike)ModRegistry.STARHAT.get()).withName("starbunclemania.cosmetic").withTextPage("starbunclemania.page.star_hat").withPage((IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.STARHAT.get())), this.getPath(FAMILIARS, "cosmetic"));
            this.addBasicItem((ItemLike)ModRegistry.PROFHAT.get(), AUTOMATION, (IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.PROFHAT.get()));
            this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ModRegistry.STARBUCKET.get()).withTextPage("starbunclemania.page.star_bucket").withPage((IPatchouliPage)new ApparatusPage((ItemLike)ModRegistry.STARBUCKET.get())).withTextPage("starbunclemania.page.fluid_scroll").withPage((IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.FLUID_SCROLL_ALLOW.get()).withRecipe2((ItemLike)ModRegistry.FLUID_SCROLL_DENY.get())), this.getPath(AUTOMATION, "star_bucket"));
            this.addBasicItem((ItemLike)ModRegistry.STARBALLON.get(), AUTOMATION, (IPatchouliPage)new ApparatusPage((ItemLike)ModRegistry.STARBALLON.get()));
            this.addBasicItem((ItemLike)ModRegistry.STARTRASH.get(), AUTOMATION, (IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.STARTRASH.get()));
            this.addBasicItem((ItemLike)ModRegistry.STARBATTERY.get(), AUTOMATION, (IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.STARBATTERY.get()));
            this.addBasicItem((ItemLike)ModRegistry.STARSADDLE.get(), AUTOMATION, (IPatchouliPage)new ApparatusPage((ItemLike)ModRegistry.STARSADDLE.get()));
            this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.WIXIE_CHARM.get()).withName("starbunclemania.wixie_jobs").withTextPage("starbunclemania.page.wixie_cook").withTextPage("starbunclemania.page.wixie_cut"), this.getPath(AUTOMATION, "wixie_jobs"));
            this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ModRegistry.STARBY_EARS.get()).withName("starbunclemania.player_cosmetic").withTextPage("starbunclemania.page.player_cosmetic").withPage((IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.STARBY_EARS.get())).withPage((IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.ALAK_HAT.get()).withRecipe2((ItemLike)ModRegistry.SEA_BUNNY.get())).withPage((IPatchouliPage)new CraftingPage((ItemLike)ModRegistry.DRYGMY_HORNS.get()).withRecipe2((ItemLike)ModRegistry.WHIRLI_PROP.get())), this.getPath(EQUIPMENT, "player_cosmetic"));
            for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
                this.saveStable(cache, (JsonElement)patchouliPage.build(), patchouliPage.path());
            }
        }

        public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
            PatchouliBuilder builder = new PatchouliBuilder(category, item.asItem().getDescriptionId()).withIcon((ItemLike)item.asItem()).withPage((IPatchouliPage)new TextPage("starbunclemania.page." + RegistryHelper.getRegistryName((Item)item.asItem()).getPath())).withPage(recipePage);
            PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, RegistryHelper.getRegistryName((Item)item.asItem()).getPath()));
            this.pages.add(page);
            return page;
        }

        public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
            PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity.starbunclemania." + familiarHolder.getRegistryName().getPath()).withIcon("starbunclemania:" + familiarHolder.getRegistryName().getPath()).withTextPage("starbunclemania.familiar_desc." + familiarHolder.getRegistryName().getPath()).withPage((IPatchouliPage)new EntityPage(familiarHolder.getRegistryName().toString()));
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(FAMILIARS, familiarHolder.getRegistryName().getPath())));
        }

        public void addGlyphPage(AbstractSpellPart spellPart) {
            ResourceLocation category = switch (spellPart.defaultTier().value) {
                case 1 -> GLYPHS_1;
                case 2 -> GLYPHS_2;
                default -> GLYPHS_3;
            };
            PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName("starbunclemania.glyph_name." + spellPart.getRegistryName().getPath()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage("starbunclemania.glyph_desc." + spellPart.getRegistryName().getPath())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().getPath())));
        }

        @NotNull
        public String getName() {
            return "StarbuncleMania Patchouli Datagen";
        }

        ImbuementPage ImbuementPage(ItemLike item) {
            return new ImbuementPage("starbunclemania:imbuement_" + RegistryHelper.getRegistryName((Item)item.asItem()).getPath());
        }
    }

    public static class ImbuementProvider
    extends ImbuementRecipeProvider {
        public ImbuementProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
        }

        protected Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/starbunclemania/recipe/" + str + ".json");
        }

        @NotNull
        public String getName() {
            return "Starbunclemania Imbuement";
        }
    }

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput pOutput) {
            this.addEntries();
            for (ApparatusRecipeBuilder.RecipeWrapper wrapper : this.recipes) {
                Path path = EnchantingAppProvider.getRecipePath(this.output, wrapper.id().getPath());
                this.saveStable(pOutput, wrapper.serialize(), path);
            }
        }

        public void addEntries() {
            this.recipes.add(this.builder().withReagent((ItemLike)ModRegistry.FLUID_JAR.get()).withPedestalItem(4, Tags.Items.NUGGETS_GOLD).withResult((ItemLike)ModRegistry.STARBUCKET.get()).build());
            this.recipes.add(this.builder().withReagent(Ingredient.of((TagKey)ItemTags.WOOL)).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(2, (ItemLike)ItemsRegistry.MAGE_FIBER).withResult((ItemLike)ModRegistry.STARBALLON.get()).build());
            this.recipes.add(this.builder().withReagent((ItemLike)Items.SADDLE).withPedestalItem(2, Ingredient.of((TagKey)ItemTagProvider.SOURCE_GEM_TAG)).withPedestalItem(2, Ingredient.of((TagKey)Tags.Items.NUGGETS_GOLD)).withResult((ItemLike)ModRegistry.STARSADDLE.get()).build());
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/starbunclemania/recipe/" + str + ".json");
        }

        @NotNull
        public String getName() {
            return "Starbunclemania Apparatus";
        }
    }

    public static class GlyphProvider
    extends GlyphRecipeProvider {
        public GlyphProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            this.add(this.get((AbstractSpellPart)PickupFluidEffect.INSTANCE).withItem((ItemLike)ModRegistry.FLUID_JAR.get()).withItem((ItemLike)Items.HOPPER));
            this.add(this.get((AbstractSpellPart)PlaceFluidEffect.INSTANCE).withItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withItem((ItemLike)Items.DISPENSER));
            Path output = this.generator.getPackOutput().getOutputFolder();
            for (GlyphRecipe recipe : this.recipes) {
                Path path = GlyphProvider.getScribeGlyphPath(output, recipe.output.getItem());
                this.saveStable(cache, (JsonElement)GlyphRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).getOrThrow(), path);
            }
        }

        protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
            return pathIn.resolve("data/starbunclemania/recipe/" + RegistryHelper.getRegistryName((Item)glyph).getPath() + ".json");
        }

        @NotNull
        public String getName() {
            return "Starbunclemania Glyph Recipes";
        }
    }
}

