/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block.wixie_stations;

import alexthw.starbunclemania.registry.FarmerDelightCompat;
import alexthw.starbunclemania.wixie.FarmerDelightRecipeWrappers;
import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FarmerPotWixieCauldronTile
extends WixieCauldronTile
implements GeoBlockEntity {
    private boolean isMixing;
    public static final RawAnimation stir = RawAnimation.begin().thenLoop("animation.pot_stirrer.stir");
    private final AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FarmerPotWixieCauldronTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @NotNull
    public BlockEntityType<?> getType() {
        return (BlockEntityType)FarmerDelightCompat.COOKING_POT_WIXIE_CAULDRON_TILE.get();
    }

    public MultiRecipeWrapper getRecipesForStack(ItemStack stack) {
        return FarmerDelightRecipeWrappers.PotRecipeWrapper.fromStack(stack, this.level);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putBoolean("isMixing", this.isMixing);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.isMixing = compound.getBoolean("isMixing");
    }

    public void onCraftStart() {
        this.isMixing = true;
        this.updateBlock();
        super.onCraftStart();
    }

    public void onCraftingComplete() {
        this.isMixing = false;
        this.setChanged();
        super.onCraftingComplete();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "rotate_controller", 40, e -> this.isMixing ? e.setAndContinue(stir) : PlayState.STOP));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }
}

