/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common;

import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.items.data.StarbuncleCharmData;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public class StarbyMountEntity
extends Starbuncle
implements PlayerRideableJumping {
    private float playerJumpPendingScale;
    private boolean isJumping;

    public StarbyMountEntity(Level world) {
        super((EntityType)ModRegistry.STARBY_MOUNT.get(), world);
        this.setTamed(true);
    }

    public StarbyMountEntity(Level world, StarbuncleCharmData.Mutable data) {
        this(world);
        this.data = data;
        this.restoreFromTag();
    }

    public StarbyMountEntity(EntityType<StarbyMountEntity> entityType, Level world) {
        super(entityType, world);
        this.setTamed(true);
    }

    public void setBehavior(ChangeableBehavior behavior) {
    }

    public void getTooltip(List<Component> tooltip) {
    }

    public void die(DamageSource source) {
        super.die(source);
        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), ((Item)ModRegistry.STARSADDLE.get()).getDefaultInstance()));
    }

    public EntityType<?> getType() {
        return (EntityType)ModRegistry.STARBY_MOUNT.get();
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean pJumping) {
        this.isJumping = pJumping;
    }

    public void travel(@NotNull Vec3 pTravelVector) {
        if (this.isAlive()) {
            LivingEntity livingEntity;
            if (this.isVehicle() && (livingEntity = this.getControllingPassenger()) instanceof Player) {
                Player livingentity = (Player)livingEntity;
                this.setYRot(livingentity.getYRot());
                this.yRotO = this.getYRot();
                this.setXRot(livingentity.getXRot() * 0.5f);
                this.setRot(this.getYRot(), this.getXRot());
                this.yHeadRot = this.yBodyRot = this.getYRot();
                float strafe = livingentity.xxa * 0.5f;
                float forward = livingentity.zza * 2.0f;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.onGround()) {
                    double d0 = (double)(this.getJumpPower() * 2.0f) * (double)this.playerJumpPendingScale * (double)this.getBlockJumpFactor();
                    double d1 = d0 + (double)this.getJumpBoostPower();
                    Vec3 vec3 = this.getDeltaMovement();
                    this.setDeltaMovement(vec3.x, d1, vec3.z);
                    this.setIsJumping(true);
                    this.hasImpulse = true;
                    CommonHooks.onLivingJump((LivingEntity)this);
                    if (forward > 0.0f) {
                        float f2 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
                        float f3 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
                        this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                if (this.isControlledByLocalInstance()) {
                    this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    super.travel(new Vec3((double)strafe, pTravelVector.y, (double)forward));
                } else {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                if (this.onGround()) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
            } else {
                super.travel(pTravelVector);
            }
        }
    }

    public void onWanded(Player playerEntity) {
        Starbuncle carbuncle = new Starbuncle(playerEntity.level(), true);
        StarbuncleCharmData.Mutable data = this.data;
        carbuncle.setPos(this.getX() + 0.5, this.getY() + 1.0, this.getZ() + 0.5);
        carbuncle.data = data;
        carbuncle.restoreFromTag();
        playerEntity.level().addFreshEntity((Entity)carbuncle);
        playerEntity.level().addFreshEntity((Entity)new ItemEntity(playerEntity.level(), this.getX(), this.getY(), this.getZ(), ((Item)ModRegistry.STARSADDLE.get()).getDefaultInstance()));
        carbuncle.onWanded(playerEntity);
        carbuncle.setBehavior((ChangeableBehavior)new StarbyTransportBehavior(carbuncle, new CompoundTag()));
        this.discard();
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (passenger instanceof Mob) {
            Mob mob = (Mob)passenger;
            if (this.getControllingPassenger() == passenger && mob.zza > 0.0f) {
                this.yBodyRot = mob.yBodyRot;
            }
        }
        if (this.hasPassenger(passenger) && passenger instanceof Player) {
            float f1 = Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180)));
            float f = Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180)));
            Vec3 vec3 = this.getPassengerRidingPosition(passenger);
            Vec3 vec31 = passenger.getVehicleAttachmentPoint((Entity)this);
            callback.accept(passenger, vec3.x - vec31.x + (double)f1 * 0.8, vec3.y - vec31.y, vec3.z - vec31.z - (double)f * 0.8);
        }
    }

    protected double getDefaultGravity() {
        if (this.getCosmeticItem().getItem() == ModRegistry.STARBALLON.get()) {
            return super.getDefaultGravity() * 0.5;
        }
        return super.getDefaultGravity();
    }

    public boolean dismountsUnderwater() {
        return false;
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity livingEntity;
        Entity entity = this.getFirstPassenger();
        return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
    }

    protected boolean canRide(@NotNull Entity pEntity) {
        return pEntity instanceof Player;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.level().isClientSide()) {
            return InteractionResult.PASS;
        }
        if (player.getMainHandItem().isEmpty() && !player.isShiftKeyDown()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void onPlayerJump(int pJumpPower) {
        if (pJumpPower < 0) {
            pJumpPower = 0;
        }
        this.playerJumpPendingScale = pJumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)pJumpPower / 90.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void handleStartJump(int pJumpPower) {
    }

    public void handleStopJump() {
    }
}

