/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.soulplied_energistics.client;

import appeng.api.client.AEKeyRenderHandler;
import com.buuz135.soulplied_energistics.applied.SoulKey;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class SoulKeyRenderHandler
implements AEKeyRenderHandler<SoulKey> {
    private List<GuiParticle> particleList = new ArrayList<GuiParticle>();
    private long lastCheckedForParticle = 0L;

    public void drawInGui(Minecraft minecraft, GuiGraphics guiGraphics, int x, int y, SoulKey soulKey) {
        int ageTick;
        guiGraphics.pose().pushPose();
        ResourceLocation warden_rl = ResourceLocation.withDefaultNamespace((String)"textures/entity/warden/warden.png");
        ResourceLocation warden_hear = ResourceLocation.withDefaultNamespace((String)"textures/entity/warden/warden_heart.png");
        guiGraphics.blit(warden_rl, x, y, 12.0f, 14.0f, 16, 16, 128, 128);
        guiGraphics.pose().pushPose();
        float heart_timing = 30.0f;
        heart_timing = 1.0f - (float)Minecraft.getInstance().level.getGameTime() % heart_timing / heart_timing;
        RenderSystem.setShaderColor((float)heart_timing, (float)heart_timing, (float)heart_timing, (float)heart_timing);
        guiGraphics.blit(warden_hear, x - 1, y - 1, 11.0f, 13.0f, 18, 18, 128, 128);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().popPose();
        long rotation = Minecraft.getInstance().level.getGameTime() % 160L - 80L;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)(y - 1), 100.0f);
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)rotation));
        guiGraphics.blit(warden_rl, 0, 0, 91.0f, 13.0f, 17, 18, 128, 128);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(x + 16), (float)(y + 17), 100.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)rotation));
        guiGraphics.blit(warden_rl, 0, 0, 91.0f, 13.0f, 17, 18, 128, 128);
        guiGraphics.pose().popPose();
        guiGraphics.pose().scale(0.75f, 0.75f, 0.75f);
        double fullAmount = 0.05;
        int xSize = 8;
        int ySize = 6;
        long currentTime = Minecraft.getInstance().level.getGameTime();
        if (this.lastCheckedForParticle != currentTime) {
            if (Minecraft.getInstance().level.random.nextDouble() <= fullAmount) {
                this.particleList.add(new GuiParticle(this, Minecraft.getInstance().level.random.nextInt(xSize), ySize - Minecraft.getInstance().level.random.nextInt(3), currentTime));
            }
            this.lastCheckedForParticle = currentTime;
        }
        if (currentTime % (long)(ageTick = 3) == 0L) {
            this.particleList.removeIf(guiParticle -> (currentTime - guiParticle.age) / (long)ageTick > 10L);
        }
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        for (GuiParticle guiParticle2 : this.particleList.reversed()) {
            double particleAge = (double)(currentTime - guiParticle2.age) / (double)ageTick;
            double extraY = (double)(ySize - 32) / 20.0 * particleAge;
            guiGraphics.blit(ResourceLocation.withDefaultNamespace((String)("textures/particle/sculk_soul_" + Math.max(0, Math.min(10, (int)particleAge)) + ".png")), (int)((float)(x + guiParticle2.x) * 1.3333334f), (int)((float)((int)((double)(y + guiParticle2.y) + extraY)) * 1.3333334f), 0.0f, 0.0f, 16, 16, 16, 16);
        }
        guiGraphics.pose().popPose();
    }

    public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource multiBufferSource, SoulKey soulKey, float v, int i, Level level) {
    }

    public Component getDisplayName(SoulKey soulKey) {
        return soulKey.getDisplayName();
    }

    private class GuiParticle {
        private int x;
        private int y;
        private long age;

        public GuiParticle(SoulKeyRenderHandler soulKeyRenderHandler, int x, int y, long age) {
            this.x = x;
            this.y = y;
            this.age = age;
        }
    }
}

