/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.SophisticatedOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ShulkerBoxBlockEntity
extends StorageBlockEntity {
    public static final String STORAGE_TYPE = "shulker_box";
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    public final SophisticatedOpenersCounter openersCounter = new SophisticatedOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            ShulkerBoxBlockEntity.this.animationStatus = AnimationStatus.OPENING;
            ShulkerBoxBlockEntity.this.playSound(state, SoundEvents.SHULKER_BOX_OPEN);
            ShulkerBoxBlockEntity.doNeighborUpdates(ShulkerBoxBlockEntity.this.getLevel(), ShulkerBoxBlockEntity.this.worldPosition, ShulkerBoxBlockEntity.this.getBlockState());
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            ShulkerBoxBlockEntity.this.animationStatus = AnimationStatus.CLOSING;
            ShulkerBoxBlockEntity.this.playSound(state, SoundEvents.SHULKER_BOX_CLOSE);
            ShulkerBoxBlockEntity.doNeighborUpdates(ShulkerBoxBlockEntity.this.getLevel(), ShulkerBoxBlockEntity.this.worldPosition, ShulkerBoxBlockEntity.this.getBlockState());
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int previousOpenCount, int openCount) {
        }

        protected boolean isOwnContainer(Player player) {
            return false;
        }
    };

    public ShulkerBoxBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE.get());
    }

    public static void tick(@Nullable Level level, BlockPos pos, BlockState state, ShulkerBoxBlockEntity blockEntity) {
        blockEntity.updateAnimation(level, pos, state);
    }

    private void updateAnimation(@Nullable Level level, BlockPos pos, BlockState state) {
        this.progressOld = this.progress;
        switch (this.animationStatus.ordinal()) {
            case 0: {
                this.progress = 0.0f;
                break;
            }
            case 1: {
                this.progress += 0.1f;
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    if (level != null) {
                        ShulkerBoxBlockEntity.doNeighborUpdates(level, pos, state);
                    }
                }
                if (level == null) break;
                this.moveCollidedEntities(level, pos, state);
                break;
            }
            case 3: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                if (level == null) break;
                ShulkerBoxBlockEntity.doNeighborUpdates(level, pos, state);
                break;
            }
            case 2: {
                this.progress = 1.0f;
            }
        }
    }

    @Override
    protected boolean isAllowedInStorage(ItemStack stack) {
        Block block = Block.byItem((Item)stack.getItem());
        return !(block instanceof ShulkerBoxBlock) && !(block instanceof net.minecraft.world.level.block.ShulkerBoxBlock) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.getItem());
    }

    private static void doNeighborUpdates(Level level, BlockPos pos, BlockState state) {
        state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState state) {
        return Shulker.getProgressAabb((float)1.0f, (Direction)((Direction)state.getValue(ShulkerBoxBlock.FACING)), (float)(0.5f * this.getProgress(1.0f)));
    }

    private void moveCollidedEntities(Level level, BlockPos pos, BlockState state) {
        Direction direction;
        AABB aabb;
        List list;
        if (state.getBlock() instanceof ShulkerBoxBlock && !(list = level.getEntities(null, aabb = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)(direction = (Direction)state.getValue(ShulkerBoxBlock.FACING)), (float)this.progressOld, (float)this.progress).move(pos))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                entity.move(MoverType.SHULKER_BOX, new Vec3((aabb.getXsize() + 0.01) * (double)direction.getStepX(), (aabb.getYsize() + 0.01) * (double)direction.getStepY(), (aabb.getZsize() + 0.01) * (double)direction.getStepZ()));
            }
        }
    }

    @Override
    public SophisticatedOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    public float getProgress(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.progressOld, (float)this.progress);
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationStatus.CLOSED;
    }

    public void setAnimationStatus(AnimationStatus animationStatus) {
        this.animationStatus = animationStatus;
    }

    @Override
    public boolean shouldDropContents() {
        return false;
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

