/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage;

import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.common.CommonEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.data.DataGenerators;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModCompat;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.init.ModParticles;
import net.p3pp3rf1y.sophisticatedstorage.init.ModPayloads;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sophisticatedstorage")
public class SophisticatedStorage {
    public static final String MOD_ID = "sophisticatedstorage";
    public static final Logger LOGGER = LogManager.getLogger((String)"sophisticatedstorage");
    private final CommonEventHandler commonEventHandler = new CommonEventHandler();

    public SophisticatedStorage(IEventBus modBus, Dist dist, ModContainer container) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        Config.SERVER.initListeners(modBus);
        this.commonEventHandler.registerHandlers();
        ModCompat.register();
        if (dist == Dist.CLIENT) {
            ClientEventHandler.registerHandlers(modBus);
        }
        ModBlocks.registerHandlers(modBus);
        ModItems.registerHandlers(modBus);
        modBus.addListener(ModPayloads::registerPayloads);
        modBus.addListener(SophisticatedStorage::setup);
        modBus.addListener(DataGenerators::gatherData);
        ModParticles.registerParticles(modBus);
    }

    private static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModBlocks::registerDispenseBehavior);
        event.enqueueWork(ModBlocks::registerCauldronInteractions);
    }

    public static ResourceLocation getRL(String regName) {
        return ResourceLocation.parse((String)SophisticatedStorage.getRegistryName(regName));
    }

    public static String getRegistryName(String regName) {
        return "sophisticatedstorage:" + regName;
    }
}

