/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum AlchemyCondition implements StringRepresentable
{
    NEVER(le -> false),
    ALWAYS(le -> true),
    UNDER_WATER(Entity::isUnderWater),
    ON_FIRE(Entity::isOnFire),
    FALLING(le -> le.fallDistance > 2.0f),
    MINING(le -> {
        if (!(le instanceof ServerPlayer)) return false;
        ServerPlayer serverPlayer = (ServerPlayer)le;
        if (!serverPlayer.gameMode.isDestroyingBlock) return false;
        return true;
    }),
    SPRINTING(Entity::isSprinting),
    HURT((le, v) -> le.getHealth() > 0.0f && le.getHealth() < le.getMaxHealth() && le.getHealth() / le.getMaxHealth() < v.floatValue(), 0.75f),
    NEGATIVE_EFFECT((le, v) -> le.getActiveEffects().stream().anyMatch(effect -> ((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL));

    public static final Codec<AlchemyCondition> CODEC;
    public static final StreamCodec<FriendlyByteBuf, AlchemyCondition> STREAM_CODEC;
    private final BiPredicate<LivingEntity, Float> predicate;
    private final float defaultValue;
    private static final Map<String, AlchemyCondition> NAME_VALUES;
    private static final AlchemyCondition[] VALUES;

    private AlchemyCondition(BiPredicate<LivingEntity, Float> predicate) {
        this(predicate, -1.0f);
    }

    private AlchemyCondition(BiPredicate<LivingEntity, Float> predicate, float defaultValue) {
        this.predicate = predicate;
        this.defaultValue = defaultValue;
    }

    private AlchemyCondition(Predicate<LivingEntity> predicate) {
        this.predicate = (le, v) -> predicate.test((LivingEntity)le);
        this.defaultValue = -1.0f;
    }

    public boolean test(LivingEntity livingEntity, float value) {
        return this.predicate.test(livingEntity, Float.valueOf(value));
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public AlchemyCondition next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static AlchemyCondition fromName(String name) {
        return NAME_VALUES.getOrDefault(name, NEVER);
    }

    public float defaultValue() {
        return this.defaultValue;
    }

    static {
        CODEC = StringRepresentable.fromEnum(AlchemyCondition::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(AlchemyCondition.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (AlchemyCondition value : AlchemyCondition.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = AlchemyCondition.values();
    }
}

