/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.reliquary;

import java.lang.reflect.Method;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyUpgradeWrapper;
import reliquary.entities.potion.ThrownPotion;
import reliquary.init.ModItems;

public class ReliquaryCompat
implements ICompat {
    private static final Method ON_HIT = ObfuscationReflectionHelper.findMethod(ThrownPotion.class, (String)"onHit", (Class[])new Class[]{HitResult.class});

    @Override
    public void setup() {
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyUpgradeWrapper.AlchemyItemDefinition(stack -> stack.getItem() == ModItems.POTION.get(), AlchemyUpgradeWrapper::getDefaultConditionForPotion, AlchemyUpgradeWrapper::shouldApplyPotionEffectsTo, AlchemyUpgradeWrapper::stackPotionEffectsMatch, ItemStack::getUseDuration, (stack, livingEntity) -> {
            ItemStack remainingItem = stack.getItem().finishUsingItem(stack, livingEntity.level(), livingEntity);
            if (livingEntity instanceof Player) {
                return remainingItem;
            }
            return new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get());
        }));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyUpgradeWrapper.AlchemyItemDefinition(stack -> stack.getItem() == ModItems.SPLASH_POTION.get(), AlchemyUpgradeWrapper::getDefaultConditionForPotion, AlchemyUpgradeWrapper::shouldApplyPotionEffectsTo, AlchemyUpgradeWrapper::stackPotionEffectsMatch, (stack, livingEntity) -> {
            Level level = livingEntity.level();
            level.playSound(null, livingEntity.getX() + (double)(livingEntity.getBbWidth() / 2.0f), livingEntity.getY(), livingEntity.getZ() + (double)(livingEntity.getBbWidth() / 2.0f), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            ThrownPotion thrownPotion = new ThrownPotion(level, (Position)new Vec3(livingEntity.getX() + (double)(livingEntity.getBbWidth() / 2.0f), livingEntity.getY() + (double)livingEntity.getEyeHeight(), livingEntity.getZ() + (double)(livingEntity.getBbWidth() / 2.0f)), stack.copy());
            level.addFreshEntity((Entity)thrownPotion);
            ReliquaryCompat.onHit(thrownPotion, (HitResult)new EntityHitResult((Entity)livingEntity, new Vec3(livingEntity.getX(), livingEntity.getY() + (double)livingEntity.getEyeHeight(), livingEntity.getZ())));
            return 1;
        }, (stack, livingEntity) -> ItemStack.EMPTY, false));
    }

    private static void onHit(ThrownPotion thrownPotion, HitResult hitResult) {
        try {
            ON_HIT.invoke((Object)thrownPotion, hitResult);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

