/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="solcarrot")
public final class MaxHealthHandler {
    private static final boolean HAS_FIRST_AID = ModList.get().isLoaded("firstaid");
    private static final ResourceLocation MILESTONE_HEALTH_MODIFIER_ID = SOLCarrot.resourceLocation("health_gained");

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MaxHealthHandler.updateFoodHPModifier(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        AttributeModifier prevModifier = MaxHealthHandler.getHealthModifier(event.getOriginal());
        if (prevModifier == null) {
            return;
        }
        MaxHealthHandler.updateHealthModifier(event.getEntity(), prevModifier);
    }

    public static boolean updateFoodHPModifier(Player player) {
        boolean hasChanged;
        AttributeModifier prevModifier = MaxHealthHandler.getHealthModifier(player);
        int healthPenalty = 2 * (SOLCarrotConfig.getBaseHearts() - 10);
        ProgressInfo progressInfo = FoodList.get(player).getProgressInfo();
        int milestonesAchieved = progressInfo.milestonesAchieved();
        int addedHealthFromFood = milestonesAchieved * 2 * SOLCarrotConfig.getHeartsPerMilestone();
        double totalHealthModifier = healthPenalty + addedHealthFromFood;
        boolean bl = hasChanged = prevModifier == null || prevModifier.amount() != totalHealthModifier;
        if (!player.level().isClientSide) {
            AttributeModifier modifier = new AttributeModifier(MILESTONE_HEALTH_MODIFIER_ID, totalHealthModifier, AttributeModifier.Operation.ADD_VALUE);
            MaxHealthHandler.updateHealthModifier(player, modifier);
        }
        return hasChanged;
    }

    @Nullable
    private static AttributeModifier getHealthModifier(Player player) {
        return MaxHealthHandler.maxHealthAttribute(player).getModifier(MILESTONE_HEALTH_MODIFIER_ID);
    }

    private static void updateHealthModifier(Player player, AttributeModifier modifier) {
        float oldMax = player.getMaxHealth();
        AttributeInstance attribute = MaxHealthHandler.maxHealthAttribute(player);
        attribute.removeModifier(modifier);
        attribute.addPermanentModifier(modifier);
        float newHealth = player.getHealth() * player.getMaxHealth() / oldMax;
        if (!HAS_FIRST_AID) {
            player.setHealth(1.0f);
        }
        player.setHealth(newHealth);
    }

    private static AttributeInstance maxHealthAttribute(Player player) {
        return Objects.requireNonNull(player.getAttribute(Attributes.MAX_HEALTH));
    }

    private MaxHealthHandler() {
    }
}

