/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.CapabilityHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.MaxHealthHandler;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;

@EventBusSubscriber(modid="solcarrot")
public final class FoodTracker {
    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        boolean isClientSide = player.level().isClientSide;
        if (SOLCarrotConfig.limitProgressionToSurvival() && player.isCreative()) {
            return;
        }
        ItemStack usedStack = event.getItem();
        if (usedStack.getFoodProperties((LivingEntity)player) == null) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        boolean hasTriedNewFood = foodList.addFood(usedStack);
        boolean newMilestoneReached = MaxHealthHandler.updateFoodHPModifier(player);
        CapabilityHandler.syncFoodList(player);
        ProgressInfo progressInfo = foodList.getProgressInfo();
        if (newMilestoneReached) {
            if (isClientSide && SOLCarrotConfig.shouldPlayMilestoneSounds()) {
                player.level().playSound(player, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (isClientSide && SOLCarrotConfig.shouldSpawnMilestoneParticles()) {
                FoodTracker.spawnParticles(player, (ParticleOptions)ParticleTypes.HEART, 12);
                if (progressInfo.hasReachedMax()) {
                    FoodTracker.spawnParticles(player, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, 16);
                }
            }
            MutableComponent heartsDescription = Localization.localizedQuantityComponent("message", "hearts", SOLCarrotConfig.getHeartsPerMilestone());
            if (isClientSide && SOLCarrotConfig.shouldShowProgressAboveHotbar()) {
                String messageKey = progressInfo.hasReachedMax() ? "finished.hotbar" : "milestone_achieved";
                player.displayClientMessage((Component)Localization.localizedComponent("message", messageKey, heartsDescription), true);
            } else {
                FoodTracker.showChatMessage(player, ChatFormatting.DARK_AQUA, (Component)Localization.localizedComponent("message", "milestone_achieved", heartsDescription));
                if (progressInfo.hasReachedMax()) {
                    FoodTracker.showChatMessage(player, ChatFormatting.GOLD, (Component)Localization.localizedComponent("message", "finished.chat", new Object[0]));
                }
            }
        } else if (hasTriedNewFood && isClientSide && SOLCarrotConfig.shouldSpawnIntermediateParticles()) {
            FoodTracker.spawnParticles(player, (ParticleOptions)ParticleTypes.END_ROD, 12);
        }
    }

    private static void spawnParticles(Player player, ParticleOptions type, int count) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        assert (connection != null);
        connection.handleParticleEvent(new ClientboundLevelParticlesPacket(type, false, player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), 0.5f, 0.5f, 0.5f, 0.0f, count));
    }

    private static void showChatMessage(Player player, ChatFormatting color, Component message) {
        MutableComponent component = Localization.localizedComponent("message", "chat_wrapper", message).withStyle(color);
        player.displayClientMessage((Component)component, false);
    }

    private FoodTracker() {
    }
}

