/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.lib;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public final class Localization {
    public static String keyString(String domain, String path) {
        return domain + ".solcarrot." + path;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localized(String domain, String path, Object ... args) {
        return I18n.get((String)Localization.keyString(domain, path), (Object[])args);
    }

    public static MutableComponent localizedComponent(String domain, String path, Object ... args) {
        return Component.translatable((String)Localization.keyString(domain, path), (Object[])args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localizedQuantity(String domain, String path, int number) {
        return number == 1 ? I18n.get((String)Localization.keyString(domain, path + ".singular"), (Object[])new Object[0]) : I18n.get((String)Localization.keyString(domain, path + ".plural"), (Object[])new Object[]{number});
    }

    public static MutableComponent localizedQuantityComponent(String domain, String path, int number) {
        return number == 1 ? Component.translatable((String)Localization.keyString(domain, path + ".singular")) : Component.translatable((String)Localization.keyString(domain, path + ".plural"), (Object[])new Object[]{number});
    }

    public static String formatBigNumber(int number) {
        if (number < 1000) {
            return "" + number;
        }
        if (number < 10000) {
            return Math.floor((float)number / 1000.0f) + "." + Math.floor((float)(number % 1000) / 100.0f) + "k";
        }
        return Math.round((float)number / 1000.0f) + "k";
    }

    private Localization() {
    }
}

