/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.smallernetherportals_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.smallernetherportals_common_neoforge.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.phys.BlockHitResult;

public class PortalEvent {
    private static final Map<String, BlockPos> toposes = new HashMap<String, BlockPos>();

    public static boolean onClick(Level level, Player player, InteractionHand hand, BlockPos clickpos, BlockHitResult hitVec) {
        if (level.isClientSide) {
            return true;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem().equals(Items.FLINT_AND_STEEL)) {
            int obsidiancount = 0;
            Iterator it = BlockPos.betweenClosedStream((int)(clickpos.getX() - 3), (int)(clickpos.getY() - 3), (int)(clickpos.getZ() - 3), (int)(clickpos.getX() + 3), (int)(clickpos.getY() + 3), (int)(clickpos.getZ() + 3)).iterator();
            while (it.hasNext()) {
                BlockPos np = (BlockPos)it.next();
                if (!Util.isObsidian(level.getBlockState(np)).booleanValue()) continue;
                ++obsidiancount;
            }
            if (obsidiancount >= 6) {
                TaskFunctions.enqueueCollectiveTask((MinecraftServer)level.getServer(), () -> {
                    BlockPos topos = clickpos;
                    boolean foundportal = false;
                    for (BlockPos np : BlockPos.betweenClosed((int)(clickpos.getX() - 1), (int)(clickpos.getY() - 1), (int)(clickpos.getZ() - 1), (int)(clickpos.getX() + 1), (int)(clickpos.getY() + 1), (int)(clickpos.getZ() + 1))) {
                        Block bsblock = level.getBlockState(np).getBlock();
                        if (bsblock instanceof NetherPortalBlock) {
                            foundportal = true;
                            continue;
                        }
                        if (!(bsblock instanceof BaseFireBlock)) continue;
                        if (Util.isAir(level.getBlockState(np.below(1))).booleanValue()) {
                            topos = np.below(1).immutable();
                            continue;
                        }
                        if (Util.isAir(level.getBlockState(np.below(2))).booleanValue()) {
                            topos = np.below(2).immutable();
                            continue;
                        }
                        topos = np.immutable();
                    }
                    if (!foundportal && Util.isAir(level.getBlockState(topos)).booleanValue()) {
                        Util.processSmallerPortal(level, topos.immutable());
                    }
                }, (int)1);
            }
        }
        return true;
    }

    public static void onDimensionChange(ServerLevel level, ServerPlayer player) {
        BlockPos foundpos;
        BlockPos pos = player.blockPosition();
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof NetherPortalBlock) {
            return;
        }
        String playername = player.getName().getString();
        if (!toposes.containsKey(playername) && (foundpos = Util.findPortalAround((Level)level, pos)) != null) {
            List<BlockPos> frontblocks = Util.getFrontBlocks((Level)level, foundpos);
            Util.setObsidian((Level)level, frontblocks);
            toposes.put(playername, frontblocks.get(frontblocks.size() - 1).above().immutable());
        }
    }

    public static void onPlayerTick(ServerLevel level, ServerPlayer player) {
        String playername = player.getName().getString();
        if (!toposes.containsKey(playername)) {
            return;
        }
        BlockPos topos = toposes.get(playername);
        player.setPortalCooldown();
        player.teleportTo((double)topos.getX() + 0.5, (double)topos.getY(), (double)topos.getZ() + 0.5);
        toposes.remove(playername);
    }
}

