/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.skeletonhorsespawn_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.HashMapFunctions;
import com.natamus.skeletonhorsespawn_common_neoforge.config.ConfigHandler;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.level.Level;

public class SkeletonHorseEvent {
    private static final HashMap<Level, CopyOnWriteArrayList<Entity>> skeletonhorses_per_world = new HashMap();
    private static final HashMap<Level, Integer> tickdelay_per_world = new HashMap();

    public static void onEntityJoin(Level level, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof SkeletonHorse && !((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(skeletonhorses_per_world, (Object)level, k -> new CopyOnWriteArrayList())).contains(entity)) {
            skeletonhorses_per_world.get(level).add(entity);
        }
    }

    public static void onWorldTick(ServerLevel level) {
        int ticks = (Integer)HashMapFunctions.computeIfAbsent(tickdelay_per_world, (Object)level, k -> 1);
        if (ticks % 20 != 0) {
            tickdelay_per_world.put((Level)level, ticks + 1);
            return;
        }
        tickdelay_per_world.put((Level)level, 1);
        if (!ConfigHandler.shouldBurnSkeletonHorsesInDaylight) {
            return;
        }
        if (!level.isDay()) {
            return;
        }
        for (Entity skeletonhorse : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(skeletonhorses_per_world, (Object)level, k -> new CopyOnWriteArrayList())) {
            if (skeletonhorse.isAlive()) {
                BlockPos epos;
                if (skeletonhorse.isInWaterRainOrBubble() || !BlockPosFunctions.isOnSurface((Level)level, (BlockPos)(epos = skeletonhorse.blockPosition())).booleanValue()) continue;
                skeletonhorse.setRemainingFireTicks(60);
                continue;
            }
            skeletonhorses_per_world.get(level).remove(skeletonhorse);
        }
    }
}

