/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets.packets.magnet;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;

public class PacketItemInfo
implements BasePacket {
    private int target;
    private UUID thrower;
    private int pickupDelay;

    public PacketItemInfo(ItemEntity itemEntity) {
        this.target = itemEntity.getId();
        this.thrower = itemEntity.thrower;
        this.pickupDelay = itemEntity.pickupDelay;
    }

    public PacketItemInfo() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.target);
        buffer.writeUUID(this.thrower);
        buffer.writeInt(this.pickupDelay);
    }

    public void read(FriendlyByteBuf buffer) {
        this.target = buffer.readInt();
        this.thrower = buffer.readUUID();
        this.pickupDelay = buffer.readInt();
    }

    public void handle(PacketContext context) {
        Player player = ClientUtils.getPlayer();
        if (player != null && player.level() != null) {
            context.queueTask(() -> {
                Entity entity = player.level().getEntity(this.target);
                if (entity instanceof ItemEntity) {
                    ((ItemEntity)entity).thrower = this.thrower;
                    ((ItemEntity)entity).setPickUpDelay(this.pickupDelay);
                }
            });
        }
    }
}

