/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.client;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.util.NameUtils;

public class GemsBlockStateProvider
extends BlockStateProvider {
    public GemsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "silentgems", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ResourceLocation flowerPotCross = this.mcLoc("block/flower_pot_cross");
        for (Gems gem : Gems.values()) {
            this.simpleBlock((Block)gem.getOre());
            this.simpleBlock((Block)gem.getDeepslateOre());
            this.simpleBlock((Block)gem.getNetherOre());
            this.simpleBlock((Block)gem.getEndOre());
            this.simpleBlock(gem.getBlock());
            this.simpleBlock(gem.getBricks());
            this.simpleBlock(gem.getTiles());
            this.simpleBlock(gem.getSmallBricks());
            this.simpleBlock(gem.getPolishedStone());
            this.simpleBlock(gem.getSmoothStone());
            this.simpleBlock(gem.getChiseledStone());
            String glass = gem.getName() + "_glass";
            this.simpleBlock((Block)gem.getGlass(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(glass, this.modLoc("block/" + glass))).renderType("translucent"));
            for (GemLampBlock.State state : GemLampBlock.State.values()) {
                this.simpleBlock(gem.getLamp(state), "block/" + gem.getName() + "_lamp" + (state.lit() ? "_on" : ""));
            }
            String glowroseName = gem.getName() + "_glowrose";
            this.simpleBlock((Block)gem.getGlowrose(), (ModelFile)((BlockModelBuilder)this.models().cross(glowroseName, this.modLoc("block/" + glowroseName))).renderType("cutout"));
            this.simpleBlock((Block)gem.getPottedGlowrose(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.fromBlock((Block)gem.getPottedGlowrose()).getPath(), flowerPotCross)).texture("plant", this.modLoc("block/" + glowroseName))).renderType("cutout"));
        }
        this.simpleBlock((Block)GemsBlocks.CHAOS_ESSENCE_BLOCK.get());
        this.simpleBlock((Block)GemsBlocks.CHAOS_ORE.get());
        this.simpleBlock((Block)GemsBlocks.DEEPSLATE_CHAOS_ORE.get());
        this.simpleBlock((Block)GemsBlocks.SILVER_BLOCK.get());
        this.simpleBlock((Block)GemsBlocks.DEEPSLATE_SILVER_ORE.get());
        this.simpleBlock((Block)GemsBlocks.SILVER_ORE.get());
    }

    private void simpleBlock(IBlockProvider block) {
        this.simpleBlock(block.asBlock());
    }

    private void simpleBlock(IBlockProvider block, String texture) {
        this.simpleBlock(block.asBlock(), texture);
    }

    private void simpleBlock(Block block, String texture) {
        String name = NameUtils.fromBlock((Block)block).getPath();
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(name, this.modLoc(texture)));
    }
}

