/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.util.Gems;

public class GemsLootTableProvider
extends LootTableProvider {
    public GemsLootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Collections.emptySet(), VanillaLootTableProvider.create((PackOutput)packOutput, lookupProvider).getTables(), lookupProvider);
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(BlockLootTables::new, LootContextParamSets.BLOCK));
    }

    private static final class BlockLootTables
    extends BlockLootSubProvider {
        private BlockLootTables(HolderLookup.Provider provider) {
            super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            for (Gems gem : Gems.values()) {
                this.registerFortuneDrops((Block)gem.getOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getDeepslateOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getNetherOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getEndOre(), gem.getItem());
                this.dropSelf(gem.getBlock());
                this.dropSelf(gem.getBricks());
                this.dropSelf(gem.getTiles());
                this.dropSelf(gem.getSmallBricks());
                this.dropSelf(gem.getPolishedStone());
                this.dropSelf(gem.getSmoothStone());
                this.dropSelf(gem.getChiseledStone());
                this.dropSelf((Block)gem.getGlass());
                for (GemLampBlock.State state : GemLampBlock.State.values()) {
                    this.dropOther(gem.getLamp(state), (ItemLike)gem.getLamp(state.withPower(false)));
                }
                this.dropSelf((Block)gem.getGlowrose());
                this.dropPottedContents((Block)gem.getPottedGlowrose());
            }
            this.add((Block)GemsBlocks.CHAOS_ORE.get(), this::createChaosOreDrops);
            this.add((Block)GemsBlocks.DEEPSLATE_CHAOS_ORE.get(), this::createChaosOreDrops);
            this.registerFortuneDrops((Block)GemsBlocks.SILVER_ORE.get(), (Item)GemsItems.RAW_SILVER.get());
            this.registerFortuneDrops((Block)GemsBlocks.DEEPSLATE_SILVER_ORE.get(), (Item)GemsItems.RAW_SILVER.get());
            this.dropSelf((Block)GemsBlocks.CHAOS_ESSENCE_BLOCK.get());
            this.dropSelf((Block)GemsBlocks.SILVER_BLOCK.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return GemsBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toList());
        }

        private void registerFortuneDrops(Block block, Item item) {
            this.add(block, this.createOreDrop(block, item));
        }

        private LootTable.Builder createChaosOreDrops(Block block) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)GemsItems.CHAOS_ESSENCE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
        }
    }
}

