/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.lib.util.MathUtils;

public final class InventoryUtils {
    private InventoryUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Collection<Slot> createPlayerSlots(Inventory playerInventory, int startX, int startY) {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                list.add(new Slot((Container)playerInventory, x + y * 9 + 9, startX + x * 18, startY + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            list.add(new Slot((Container)playerInventory, x, 8 + x * 18, startY + 58));
        }
        return list;
    }

    @Deprecated
    public static boolean canItemsStack(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack firstMatch(Container inv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack mergeItem(Container inventory, int slotStart, int slotEndExclusive, ItemStack stack) {
        int i;
        if (inventory == null || stack.isEmpty()) {
            return stack;
        }
        for (i = slotStart; i < slotEndExclusive && !stack.isEmpty(); ++i) {
            ItemStack inSlot = inventory.getItem(i);
            if (!InventoryUtils.canItemsStack(inSlot, stack)) continue;
            int amountCanFit = MathUtils.min(inSlot.getMaxStackSize() - inSlot.getCount(), stack.getCount(), inventory.getMaxStackSize());
            inSlot.grow(amountCanFit);
            stack.shrink(amountCanFit);
            inventory.setItem(i, inSlot);
        }
        for (i = slotStart; i < slotEndExclusive && !stack.isEmpty(); ++i) {
            if (!inventory.getItem(i).isEmpty()) continue;
            int amountCanFit = MathUtils.min(stack.getCount(), inventory.getMaxStackSize());
            ItemStack toInsert = stack.copy();
            toInsert.setCount(amountCanFit);
            stack.shrink(amountCanFit);
            inventory.setItem(i, toInsert);
        }
        return stack;
    }

    public static Collection<ItemStack> mergeItems(Container inventory, int slotStart, int slotEndExclusive, Collection<ItemStack> stacks) {
        if (inventory == null && stacks.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder leftovers = ImmutableList.builder();
        for (ItemStack stack : stacks) {
            if ((stack = InventoryUtils.mergeItem(inventory, slotStart, slotEndExclusive, stack)).isEmpty()) continue;
            leftovers.add((Object)stack);
        }
        return leftovers.build();
    }
}

