/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.lib.util.DimensionId;

public final class DimPos {
    public static final DimPos ZERO = new DimPos(0, 0, 0, (ResourceKey<Level>)Level.OVERWORLD);
    private final int posX;
    private final int posY;
    private final int posZ;
    private final DimensionId dimension;

    public static DimPos of(BlockPos pos, ResourceKey<Level> dimension) {
        return new DimPos(pos, dimension);
    }

    public static DimPos of(int x, int y, int z, ResourceKey<Level> dimension) {
        return new DimPos(x, y, z, dimension);
    }

    public static DimPos of(Entity entity) {
        return new DimPos(entity.blockPosition(), (ResourceKey<Level>)entity.level().dimension());
    }

    private DimPos(BlockPos pos, ResourceKey<Level> dimension) {
        this(pos.getX(), pos.getY(), pos.getZ(), dimension);
    }

    private DimPos(int x, int y, int z, ResourceKey<Level> dimension) {
        this(x, y, z, DimensionId.fromId(dimension));
    }

    private DimPos(int x, int y, int z, DimensionId dimension) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dimension = dimension;
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public int getZ() {
        return this.posZ;
    }

    public DimensionId getDimensionId() {
        return this.dimension;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension.getId();
    }

    public static DimPos read(CompoundTag tags) {
        return DimPos.of(tags.getInt("posX"), tags.getInt("posY"), tags.getInt("posZ"), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tags.getString("dim"))));
    }

    public void write(CompoundTag tags) {
        tags.putInt("posX", this.posX);
        tags.putInt("posY", this.posY);
        tags.putInt("posZ", this.posZ);
        tags.putString("dim", this.dimension.getRegistryName().toString());
    }

    public BlockPos getPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public Vec3 getPosCentered(double yOffset) {
        return new Vec3((double)this.posX + 0.5, (double)this.posY + yOffset, (double)this.posZ + 0.5);
    }

    public DimPos offset(Direction facing, int n) {
        if (n == 0) {
            return this;
        }
        return new DimPos(this.posX + facing.getStepX() * n, this.posY + facing.getStepY() * n, this.posZ + facing.getStepZ() * n, this.dimension);
    }

    public String toString() {
        return String.format("(%d, %d, %s) in %s", this.posX, this.posY, this.posZ, this.dimension.getRegistryName());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DimPos) {
            DimPos pos = (DimPos)other;
            return pos.dimension == this.dimension && pos.posX == this.posX && pos.posY == this.posY && pos.posZ == this.posZ;
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.posX + this.posY) + this.posZ) + this.dimension.getRegistryName().hashCode();
    }
}

