/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.silentchaos512.lib.network.internal.SwingItemPayload;

public interface ILeftClickItem {
    default public InteractionResultHolder<ItemStack> onItemLeftClickSL(Level world, Player player) {
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getMainHandItem());
    }

    default public InteractionResultHolder<ItemStack> onItemLeftClickBlockSL(Level world, Player player) {
        return this.onItemLeftClickSL(world, player);
    }

    public static final class EventHandler {
        private EventHandler() {
        }

        public static void init() {
            NeoForge.EVENT_BUS.addListener(EventHandler::onLeftClickBlock);
            NeoForge.EVENT_BUS.addListener(EventHandler::onLeftClickEmpty);
        }

        private static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            ILeftClickItem leftClickItem;
            InteractionResultHolder<ItemStack> result;
            Item item;
            ItemStack stack = event.getItemStack();
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof ILeftClickItem && (result = (leftClickItem = (ILeftClickItem)item).onItemLeftClickBlockSL(event.getLevel(), event.getEntity())).getResult() == InteractionResult.SUCCESS) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SwingItemPayload(Target.BLOCK), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        private static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            ILeftClickItem leftClickItem;
            InteractionResultHolder<ItemStack> result;
            Item item;
            ItemStack stack = event.getItemStack();
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof ILeftClickItem && (result = (leftClickItem = (ILeftClickItem)item).onItemLeftClickSL(event.getLevel(), event.getEntity())).getResult() == InteractionResult.SUCCESS) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SwingItemPayload(Target.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static enum Target {
        EMPTY,
        BLOCK;

        public static final StreamCodec<ByteBuf, Target> ID_STREAM_CODEC;

        static {
            ID_STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])Target.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), Enum::ordinal);
        }
    }
}

