/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.core.SoundPlayback;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.NameUtils;

public class BlockFillerTraitEffect
extends TraitEffect {
    public static final MapCodec<BlockFillerTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TargetBlock.CODEC.fieldOf("target").forGetter(e -> e.targetBlock), (App)FillProperties.CODEC.fieldOf("fill_properties").forGetter(e -> e.fillProperties), (App)UseProperties.CODEC.fieldOf("use_properties").forGetter(e -> e.useProperties), (App)SoundPlayback.CODEC.fieldOf("sound").forGetter(e -> e.sound)).apply((Applicative)instance, BlockFillerTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockFillerTraitEffect> STREAM_CODEC = StreamCodec.composite(TargetBlock.STREAM_CODEC, e -> e.targetBlock, FillProperties.STREAM_CODEC, e -> e.fillProperties, UseProperties.STREAM_CODEC, e -> e.useProperties, SoundPlayback.STREAM_CODEC, e -> e.sound, BlockFillerTraitEffect::new);
    private final TargetBlock targetBlock;
    private final FillProperties fillProperties;
    private final UseProperties useProperties;
    private final SoundPlayback sound;

    public BlockFillerTraitEffect(TargetBlock targetBlock, FillProperties fillProperties, UseProperties useProperties, SoundPlayback sound) {
        this.targetBlock = targetBlock;
        this.fillProperties = fillProperties;
        this.useProperties = useProperties;
        this.sound = sound;
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.BLOCK_FILLER.get();
    }

    @Override
    public InteractionResult onItemUse(UseOnContext context, int traitLevel) {
        boolean hasEnoughDurability;
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown() && this.useProperties.sneakMode == SneakMode.PASS) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos center = context.getClickedPos();
        int rangeX = this.shouldConstrain(context, Direction.Axis.X) ? 0 : this.fillProperties.rangeX;
        int rangeY = this.shouldConstrain(context, Direction.Axis.Y) ? 0 : this.fillProperties.rangeY;
        int rangeZ = this.shouldConstrain(context, Direction.Axis.Z) ? 0 : this.fillProperties.rangeZ;
        int replaceCount = this.replaceBlocks(context, stack, world, center, rangeX, rangeY, rangeZ, true);
        int durabilityCost = Math.round(this.useProperties.damagePerBlock * (float)replaceCount);
        boolean bl = hasEnoughDurability = durabilityCost < 1 || stack.getDamageValue() < stack.getMaxDamage() - durabilityCost;
        if (player != null && player.level().isClientSide) {
            return replaceCount > 0 && hasEnoughDurability ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (hasEnoughDurability) {
            this.replaceBlocks(context, stack, world, center, rangeX, rangeY, rangeZ, false);
        }
        if (replaceCount > 0) {
            if (this.useProperties.damagePerBlock > 0.0f && player != null) {
                GearHelper.attemptDamage(stack, durabilityCost, (LivingEntity)player, context.getHand());
            }
            if (this.sound != null) {
                this.sound.playAt(player.level(), context.getClickedPos(), SoundSource.BLOCKS);
            }
            if (this.useProperties.cooldown > 0) {
                player.getCooldowns().addCooldown(stack.getItem(), this.useProperties.cooldown);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private int replaceBlocks(UseOnContext context, ItemStack stack, Level world, BlockPos center, int rangeX, int rangeY, int rangeZ, boolean simulate) {
        int count = 0;
        for (int x = center.getX() - rangeX; x <= center.getX() + rangeX; ++x) {
            for (int y = center.getY() - rangeY; y <= center.getY() + rangeY; ++y) {
                for (int z = center.getZ() - rangeZ; z <= center.getZ() + rangeZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.getBlockState(pos);
                    if (!this.targetBlock.test(state) || !this.fillProperties.replaceBlockEntities && world.getBlockEntity(pos) != null) continue;
                    if (!simulate) {
                        world.setBlock(pos, this.fillProperties.block.defaultBlockState(), 11);
                    }
                    ++count;
                }
            }
        }
        return count;
    }

    private boolean shouldConstrain(UseOnContext context, Direction.Axis axis) {
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown() && this.useProperties.sneakMode == SneakMode.CONSTRAIN) {
            return true;
        }
        return this.fillProperties.facingPlaneOnly && context.getClickedFace().getAxis() == axis;
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("  - Fills with: " + String.valueOf(NameUtils.fromBlock((Block)this.fillProperties.block)));
        ret.add("  - Replaces");
        if (this.targetBlock.tag != null) {
            ret.add("    - Tag: " + String.valueOf(this.targetBlock.tag.location()));
        }
        if (this.targetBlock.block != null) {
            ret.add("    - Block: " + String.valueOf(NameUtils.fromBlock((Block)this.targetBlock.block)));
        }
        ret.add("    - " + (this.fillProperties.replaceBlockEntities ? "Replaces" : "Does not replace") + " block entities");
        int fillX = 2 * this.fillProperties.rangeX + 1;
        int fillY = 2 * this.fillProperties.rangeY + 1;
        int fillZ = 2 * this.fillProperties.rangeZ + 1;
        ret.add("  - Fill Area");
        ret.add("    - X: " + fillX + " (+" + this.fillProperties.rangeX + ")");
        ret.add("    - Y: " + fillY + " (+" + this.fillProperties.rangeY + ")");
        ret.add("    - Z: " + fillZ + " (+" + this.fillProperties.rangeZ + ")");
        if (this.fillProperties.facingPlaneOnly) {
            ret.add("    - Fills facing plane only");
        }
        ret.add("    - On sneak: " + this.useProperties.sneakMode.name());
        ret.add("  - Durability Cost: " + this.useProperties.damagePerBlock);
        if (this.useProperties.cooldown > 0) {
            ret.add("  - Cooldown: " + this.useProperties.cooldown);
        }
        return ret;
    }

    public record TargetBlock(@Nullable Block block, @Nullable TagKey<Block> tag) implements Predicate<BlockState>
    {
        public static final Codec<TargetBlock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("block").forGetter(t -> Optional.ofNullable(t.block)), (App)TagKey.codec((ResourceKey)Registries.BLOCK).optionalFieldOf("tag").forGetter(t -> Optional.ofNullable(t.tag))).apply((Applicative)instance, (block1, tag1) -> new TargetBlock(block1.orElse(null), (TagKey<Block>)((TagKey)tag1.orElse(null)))));
        public static final StreamCodec<RegistryFriendlyByteBuf, TargetBlock> STREAM_CODEC = StreamCodec.of((buf, val) -> {
            buf.writeBoolean(val.block != null);
            if (val.block != null) {
                buf.writeResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)val.block));
            }
            buf.writeBoolean(val.tag != null);
            if (val.tag != null) {
                buf.writeResourceLocation(val.tag.location());
            }
        }, buf -> {
            Block block = null;
            TagKey tag = null;
            if (buf.readBoolean()) {
                block = (Block)BuiltInRegistries.BLOCK.get(buf.readResourceLocation());
            }
            if (buf.readBoolean()) {
                tag = BlockTags.create((ResourceLocation)buf.readResourceLocation());
            }
            return new TargetBlock(block, (TagKey<Block>)tag);
        });

        @Override
        public boolean test(BlockState state) {
            return this.block != null && state.is(this.block) || this.tag != null && state.is(this.tag);
        }
    }

    public record FillProperties(Block block, boolean replaceBlockEntities, int rangeX, int rangeY, int rangeZ, boolean facingPlaneOnly) {
        public static final Codec<FillProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(p -> p.block), (App)Codec.BOOL.fieldOf("replace_block_entities").forGetter(p -> p.replaceBlockEntities), (App)Codec.INT.fieldOf("range_x").forGetter(p -> p.rangeX), (App)Codec.INT.fieldOf("range_y").forGetter(p -> p.rangeY), (App)Codec.INT.fieldOf("range_z").forGetter(p -> p.rangeZ), (App)Codec.BOOL.fieldOf("facing_plane_only").forGetter(p -> p.facingPlaneOnly)).apply((Applicative)instance, FillProperties::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FillProperties> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), p -> p.block, (StreamCodec)ByteBufCodecs.BOOL, p -> p.replaceBlockEntities, (StreamCodec)ByteBufCodecs.VAR_INT, p -> p.rangeX, (StreamCodec)ByteBufCodecs.VAR_INT, p -> p.rangeY, (StreamCodec)ByteBufCodecs.VAR_INT, p -> p.rangeZ, (StreamCodec)ByteBufCodecs.BOOL, p -> p.facingPlaneOnly, FillProperties::new);
    }

    public record UseProperties(SneakMode sneakMode, float damagePerBlock, int cooldown) {
        public static final Codec<UseProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SneakMode.CODEC.fieldOf("sneak_mode").forGetter(p -> p.sneakMode), (App)Codec.FLOAT.fieldOf("damage_per_block").forGetter(p -> Float.valueOf(p.damagePerBlock)), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(p -> p.cooldown)).apply((Applicative)instance, UseProperties::new));
        public static final StreamCodec<FriendlyByteBuf, UseProperties> STREAM_CODEC = StreamCodec.composite(SneakMode.STREAM_CODEC, p -> p.sneakMode, (StreamCodec)ByteBufCodecs.FLOAT, p -> Float.valueOf(p.damagePerBlock), (StreamCodec)ByteBufCodecs.VAR_INT, p -> p.cooldown, UseProperties::new);
    }

    public static enum SneakMode implements StringRepresentable
    {
        PASS,
        CONSTRAIN,
        IGNORE;

        public static final Codec<SneakMode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, SneakMode> STREAM_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(SneakMode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(SneakMode.class);
        }
    }
}

