/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearHelper;

public final class PartInstance
implements GearComponentInstance<GearPart> {
    public static final Codec<PartInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DataResource.PART_CODEC.fieldOf("part").forGetter(p -> p.part), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("item", (Object)ItemStack.EMPTY).forGetter(p -> p.craftingItem)).apply((Applicative)instance, PartInstance::of));
    public static final StreamCodec<RegistryFriendlyByteBuf, PartInstance> STREAM_CODEC = StreamCodec.composite(DataResource.PART_STREAM_CODEC, p -> p.part, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, p -> p.craftingItem, PartInstance::new);
    private static final Map<ResourceLocation, PartInstance> CACHE_UNGRADED_PARTS = new HashMap<ResourceLocation, PartInstance>();
    private final DataResource<GearPart> part;
    private final ItemStack craftingItem;

    private PartInstance(DataResource<GearPart> part) {
        this(part, ItemStack.EMPTY);
    }

    private PartInstance(DataResource<GearPart> part, ItemStack craftingItem) {
        this.part = part;
        this.craftingItem = craftingItem.copy();
        if (!this.craftingItem.isEmpty()) {
            this.craftingItem.setCount(1);
        }
    }

    public static PartInstance of(DataResource<GearPart> part) {
        return new PartInstance(part);
    }

    public static PartInstance of(GearPart part) {
        return new PartInstance(DataResource.part(SgRegistries.PART.getKey(part)));
    }

    public static PartInstance of(DataResource<GearPart> part, ItemStack craftingItem) {
        return new PartInstance(part, craftingItem);
    }

    public static PartInstance of(GearPart part, ItemStack craftingItem) {
        return new PartInstance(DataResource.part(SgRegistries.PART.getKey(part)), craftingItem);
    }

    public static PartInstance create(DataResource<GearPart> part, CompoundPartItem item, DataResource<Material> material) {
        return PartInstance.create(part, item, List.of(MaterialInstance.of(material)));
    }

    public static PartInstance create(DataResource<GearPart> part, CompoundPartItem item, List<MaterialInstance> materials) {
        ItemStack partStack = new ItemStack((ItemLike)item);
        partStack.set(SgDataComponents.MATERIAL_LIST, materials);
        return new PartInstance(part, partStack);
    }

    @Nullable
    public static PartInstance from(ItemStack craftingItem) {
        return PartInstance.from(craftingItem, true);
    }

    @Nullable
    public static PartInstance from(ItemStack craftingItem, boolean checkSubstitutes) {
        GearPart part = SgRegistries.PART.fromItem(craftingItem);
        if (part == null) {
            if (checkSubstitutes) {
                return PartInstance.fromMaterialSubstitute(craftingItem);
            }
            return null;
        }
        return PartInstance.of(part, craftingItem);
    }

    @Nullable
    private static PartInstance fromMaterialSubstitute(ItemStack stack) {
        for (Material material : SgRegistries.MATERIAL.getValues(true)) {
            if (!material.hasPartSubstitutes()) continue;
            for (PartType partType : SgRegistries.PART_TYPE) {
                Optional<? extends CompoundPartItem> item;
                Optional<Ingredient> ingredient = material.getPartSubstitute(partType);
                if (!ingredient.isPresent() || !ingredient.get().test(stack) || !(item = partType.getCompoundPartItem((GearType)GearTypes.ALL.get())).isPresent()) continue;
                ItemStack result = item.get().create(MaterialInstance.of(material));
                return PartInstance.from(result, false);
            }
        }
        return null;
    }

    public boolean isValid() {
        return this.part.isPresent();
    }

    @Override
    public ResourceLocation getId() {
        return this.part.getId();
    }

    @Override
    @Nonnull
    public GearPart get() {
        return this.part.get();
    }

    @Nullable
    public GearPart getNullable() {
        return this.part.getNullable();
    }

    @Override
    public ItemStack getItem() {
        return this.craftingItem;
    }

    public PartType getType() {
        return this.part.map(GearPart::getType).orElse((PartType)PartTypes.NONE.get());
    }

    public GearType getGearType() {
        return this.part.map(GearPart::getGearType).orElse((GearType)GearTypes.NONE.get());
    }

    public PartGearKey getKey() {
        return PartGearKey.of(this.getGearType(), this.getType());
    }

    public List<MaterialInstance> getMaterials() {
        GearPart part = this.getNullable();
        return part != null ? part.getMaterials(this) : List.of();
    }

    @Nullable
    public MaterialInstance getPrimaryMaterial() {
        GearPart part = this.getNullable();
        return part != null ? part.getPrimaryMaterial(this) : null;
    }

    @Override
    public <T, V extends GearPropertyValue<T>> T getProperty(PartType partType, PropertyKey<T, V> key) {
        return key.property().compute(key.property().getBaseValue(), this.getPropertyModifiers(partType, key));
    }

    @Override
    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(PartType partType, PropertyKey<T, V> key) {
        GearPart part = this.getNullable();
        return part != null ? part.getPropertyModifiers(this, partType, key) : Collections.emptyList();
    }

    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(PropertyKey<T, V> key) {
        return this.getPropertyModifiers(this.getType(), key);
    }

    public boolean isCraftingAllowed(GearType gearType, @Nullable CraftingInput inventory) {
        GearPart part = this.getNullable();
        return part != null && part.isCraftingAllowed(this, this.getType(), gearType, inventory);
    }

    public Component getMaterialName(ItemStack gear) {
        GearPart part = this.getNullable();
        return part != null ? part.getMaterialName(this, gear) : Component.empty();
    }

    @Override
    public int getNameColor(PartType partType, GearType gearType) {
        return 0xFFFFFF;
    }

    public Component getDisplayName() {
        return this.getDisplayName(this.getType());
    }

    @Override
    public Component getDisplayName(PartType type, ItemStack gear) {
        GearPart part = this.getNullable();
        return part != null ? part.getDisplayName(this, type) : Component.empty();
    }

    public String getModelKey() {
        GearPart part = this.getNullable();
        return part != null ? part.getModelKey(this) : "null";
    }

    public int getColor(ItemStack gear) {
        return this.getColor(gear, 0, 0);
    }

    public int getColor(ItemStack gear, int layer, int animationFrame) {
        return this.getColor(GearHelper.getType(gear), layer, animationFrame);
    }

    public int getColor(GearType gearType, int layer, int animationFrame) {
        GearPart part = this.getNullable();
        if (part != null) {
            return part.getColor(this, gearType, layer, animationFrame);
        }
        return 0xFFFFFF;
    }

    public void onAddToGear(ItemStack gear) {
        if (this.part.isPresent()) {
            this.part.get().onAddToGear(gear, this);
        }
    }

    public void onRemoveFromGear(ItemStack gear) {
        if (this.part.isPresent()) {
            this.part.get().onRemoveFromGear(gear, this);
        }
    }

    public void addInformation(ItemStack gear, List<Component> tooltip, TooltipFlag flag) {
        if (this.part.isPresent()) {
            this.part.get().addInformation(this, gear, tooltip, flag);
        }
    }

    public String toString() {
        return "PartInstance{" + String.valueOf(this.part) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartInstance otherPart = (PartInstance)o;
        return this.part.equals(otherPart.part) && ItemStack.isSameItemSameComponents((ItemStack)this.craftingItem, (ItemStack)otherPart.craftingItem);
    }

    public int hashCode() {
        return Objects.hash(this.part, ItemStack.hashItemAndComponents((ItemStack)this.craftingItem));
    }
}

