/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetPropertyModifiersEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartCraftingData;
import net.silentchaos512.gear.api.part.PartDisplayData;
import net.silentchaos512.gear.api.part.PartSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;

public class CoreGearPart
extends AbstractGearPart {
    protected final GearType gearType;
    protected final PartType partType;

    public CoreGearPart(GearType gearType, PartType partType, PartCraftingData crafting, PartDisplayData display, GearPropertyMap properties) {
        super(crafting, display, properties);
        this.gearType = gearType;
        this.partType = partType;
    }

    @Override
    public PartType getType() {
        return this.partType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public PartSerializer<?> getSerializer() {
        return (PartSerializer)PartSerializers.CORE.get();
    }

    @Override
    public List<MaterialInstance> getMaterials(PartInstance part) {
        return (List)part.getItem().getOrDefault(SgDataComponents.MATERIAL_LIST, List.of());
    }

    @Override
    @Nullable
    public MaterialInstance getPrimaryMaterial(PartInstance part) {
        List<MaterialInstance> materials = this.getMaterials(part);
        return materials.isEmpty() ? null : materials.getFirst();
    }

    @Override
    public int getColor(PartInstance part, GearType gearType, int layer, int animationFrame) {
        MaterialInstance primaryMaterial = this.getPrimaryMaterial(part);
        return primaryMaterial != null ? primaryMaterial.getColor(gearType, this.partType) : 0xFFFFFF;
    }

    @Override
    public Component getDisplayName(@Nullable PartInstance part) {
        if (part != null) {
            return part.getItem().getHoverName();
        }
        return super.getDisplayName(null);
    }

    @Override
    public Component getDisplayNamePrefix(@Nullable PartInstance part, ItemStack gear) {
        MaterialInstance material;
        if (part != null && (material = this.getPrimaryMaterial(part)) != null) {
            return material.getDisplayNamePrefix(this.partType);
        }
        return super.getDisplayNamePrefix(part, gear);
    }

    @Override
    public Component getMaterialName(@Nullable PartInstance part, ItemStack gear) {
        MaterialInstance material;
        if (part != null && (material = this.getPrimaryMaterial(part)) != null) {
            return material.getDisplayName(this.partType, gear);
        }
        return super.getMaterialName(null, gear);
    }

    @Override
    public String getModelKey(PartInstance part) {
        MaterialInstance primaryMaterial = this.getPrimaryMaterial(part);
        String str = "{" + (primaryMaterial != null ? primaryMaterial.getModelKey() : "null") + "}";
        return super.getModelKey(part) + str;
    }

    @Override
    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(PartInstance part, PartType partType, PropertyKey<T, V> key) {
        if (key.property().isForMaterialsOnly()) {
            return List.of();
        }
        List<MaterialInstance> materials = this.getMaterials(part);
        List mods = materials.stream().flatMap(m -> m.getPropertyModifiers(partType, key).stream()).collect(Collectors.toList());
        mods.addAll(this.properties.getValues(key));
        if (mods.isEmpty()) {
            return mods;
        }
        GetPropertyModifiersEvent<T, V> event = new GetPropertyModifiersEvent<T, V>(part, key, mods);
        NeoForge.EVENT_BUS.post(event);
        List<V> modifiers = event.getModifiers();
        return key.property().compressModifiers(modifiers, part.getKey(), List.of(part));
    }

    @Override
    public PartInstance randomizeData(GearType gearType, int tier) {
        for (ItemStack stack : this.getIngredient().getItems()) {
            if (!(stack.getItem() instanceof CompoundPartItem)) continue;
            MaterialInstance material = this.getRandomMaterial(gearType);
            ItemStack craftingItem = ((CompoundPartItem)stack.getItem()).create(material);
            return PartInstance.of(this, craftingItem);
        }
        return super.randomizeData(gearType, tier);
    }

    @Override
    public boolean canAddToGear(ItemStack gear, PartInstance part) {
        GearType type = GearHelper.getType(gear);
        return type.matches(this.gearType);
    }

    private MaterialInstance getRandomMaterial(GearType gearType) {
        List<Material> allParentMaterials = SgRegistries.MATERIAL.getValues(false).stream().map(MaterialInstance::of).filter(m -> m.allowedInPart(this.partType) && m.isCraftingAllowed(this.partType, gearType)).map(MaterialInstance::get).toList();
        if (!allParentMaterials.isEmpty()) {
            Material material = allParentMaterials.get(SilentGear.RANDOM.nextInt(allParentMaterials.size()));
            return CoreGearPart.getRandomChildMaterial(material);
        }
        return MaterialInstance.of(Const.Materials.EXAMPLE);
    }

    private static MaterialInstance getRandomChildMaterial(Material material) {
        List<Material> children = SgRegistries.MATERIAL.getChildren(material);
        if (children.isEmpty()) {
            return MaterialInstance.of(material);
        }
        return MaterialInstance.of(children.get(SilentGear.RANDOM.nextInt(children.size())));
    }

    @Override
    public String toString() {
        return "CompoundPart{id=" + String.valueOf(SgRegistries.PART.getKey(this)) + ", partType=" + String.valueOf(this.partType) + "}";
    }

    public static class Serializer
    extends PartSerializer<CoreGearPart> {
        private static final MapCodec<CoreGearPart> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GearType.CODEC.fieldOf("gear_type").forGetter(p -> p.gearType), (App)PartType.CODEC.fieldOf("part_type").forGetter(p -> p.partType), (App)PartCraftingData.CODEC.fieldOf("crafting").forGetter(p -> p.crafting), (App)PartDisplayData.CODEC.fieldOf("display").forGetter(p -> p.display), (App)GearPropertyMap.CODEC.fieldOf("properties").forGetter(p -> p.properties)).apply((Applicative)instance, CoreGearPart::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, CoreGearPart> STREAM_CODEC = StreamCodec.composite(GearType.STREAM_CODEC, p -> p.gearType, PartType.STREAM_CODEC, p -> p.partType, PartCraftingData.STREAM_CODEC, p -> p.crafting, PartDisplayData.STREAM_CODEC, p -> p.display, GearPropertyMap.STREAM_CODEC, p -> p.properties, CoreGearPart::new);

        public Serializer() {
            super(CODEC, STREAM_CODEC);
        }
    }
}

