/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.util.GsonHelper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.data.MaterialsProvider;
import net.silentchaos512.gear.data.ModAdvancementProvider;
import net.silentchaos512.gear.data.ModBlockTagsProvider;
import net.silentchaos512.gear.data.ModDataMapProvider;
import net.silentchaos512.gear.data.ModItemTagsProvider;
import net.silentchaos512.gear.data.ModSoundDefinitionsProvider;
import net.silentchaos512.gear.data.PartsProvider;
import net.silentchaos512.gear.data.client.CompoundModelsProvider;
import net.silentchaos512.gear.data.client.ModBlockStateProvider;
import net.silentchaos512.gear.data.client.ModItemModelProvider;
import net.silentchaos512.gear.data.loot.ModLootModifierProvider;
import net.silentchaos512.gear.data.loot.ModLootTables;
import net.silentchaos512.gear.data.recipes.ModRecipesProvider;
import net.silentchaos512.gear.data.trait.TraitsProvider;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ModDataMapProvider(packOutput, lookupProvider));
        ModBlockTagsProvider blocks = new ModBlockTagsProvider(event);
        generator.addProvider(true, (DataProvider)blocks);
        generator.addProvider(true, (DataProvider)new ModItemTagsProvider(event, blocks));
        generator.addProvider(true, (DataProvider)new TraitsProvider(generator));
        generator.addProvider(true, (DataProvider)new MaterialsProvider(generator, "silentgear"));
        generator.addProvider(true, (DataProvider)new PartsProvider(generator));
        generator.addProvider(true, (DataProvider)new ModLootTables(event));
        generator.addProvider(true, (DataProvider)new ModLootModifierProvider(event));
        generator.addProvider(true, (DataProvider)new ModRecipesProvider(event));
        generator.addProvider(true, (DataProvider)new ModAdvancementProvider(event));
        generator.addProvider(true, (DataProvider)new ModBlockStateProvider(generator, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ModItemModelProvider(generator, existingFileHelper));
        generator.addProvider(true, (DataProvider)new CompoundModelsProvider(generator, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ModSoundDefinitionsProvider(packOutput, existingFileHelper));
    }

    public static CompletableFuture<?> saveStable(CachedOutput p_253653_, JsonElement p_254542_, Path p_254467_) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
                try (JsonWriter jsonwriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8));){
                    jsonwriter.setSerializeNulls(false);
                    jsonwriter.setIndent("  ");
                    GsonHelper.writeValue((JsonWriter)jsonwriter, (JsonElement)p_254542_, null);
                }
                p_253653_.writeIfNeeded(p_254467_, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
            }
            catch (IOException ioexception) {
                SilentGear.LOGGER.error("Failed to save file to {}", (Object)p_254467_, (Object)ioexception);
            }
        }, Util.backgroundExecutor());
    }
}

