/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.salvage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgRecipes;

public class CompoundPartSalvagingRecipe
extends SalvagingRecipe {
    public CompoundPartSalvagingRecipe() {
        super(Ingredient.of((ItemLike[])((ItemLike[])SgItems.getItems(CompoundPartItem.class).toArray(new CompoundPartItem[0]))), Collections.emptyList());
    }

    @Override
    public List<ItemStack> getPossibleResults(Container inv) {
        ItemStack input = inv.getItem(0);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        PartInstance part = PartInstance.from(input);
        if (part != null) {
            ret.addAll(CompoundPartSalvagingRecipe.salvagePart(part));
        }
        return ret;
    }

    @Override
    public boolean matches(SingleRecipeInput input, Level level) {
        ItemStack stack = input.getItem(0);
        return stack.getMaxStackSize() == 1 && stack.getItem() instanceof CompoundPartItem && PartInstance.from(stack) != null;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SgRecipes.SALVAGING_COMPOUND_PART.get();
    }

    public static class Serializer
    implements RecipeSerializer<CompoundPartSalvagingRecipe> {
        public static final MapCodec<CompoundPartSalvagingRecipe> CODEC = Codec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(CompoundPartSalvagingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CompoundPartSalvagingRecipe> STREAM_CODEC = StreamCodec.of((buf, r) -> {}, buf -> new CompoundPartSalvagingRecipe());

        public MapCodec<CompoundPartSalvagingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CompoundPartSalvagingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

