/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class QuickRepairRecipe
extends CustomRecipe {
    public QuickRepairRecipe(CraftingBookCategory bookCategory) {
        super(bookCategory);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack gear = ItemStack.EMPTY;
        boolean foundKit = false;
        float repairKitEfficiency = ((Double)Config.Common.missingRepairKitEfficiency.get()).floatValue();
        ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof GearItem) {
                if (!gear.isEmpty()) {
                    return false;
                }
                gear = stack;
                continue;
            }
            if (stack.getItem() instanceof RepairKitItem) {
                if (foundKit) {
                    return false;
                }
                foundKit = true;
                repairKitEfficiency = QuickRepairRecipe.getKitEfficiency(stack);
                continue;
            }
            if (MaterialInstance.from(stack) != null) {
                materials.add(stack);
                continue;
            }
            return false;
        }
        if (gear.isEmpty() || (double)repairKitEfficiency < 1.0E-10) {
            return false;
        }
        for (ItemStack stack : materials) {
            if (SgRecipes.isRepairMaterial(gear, stack)) continue;
            return false;
        }
        return true;
    }

    private static float getKitEfficiency(ItemStack stack) {
        if (stack.getItem() instanceof RepairKitItem) {
            return ((RepairKitItem)stack.getItem()).getRepairEfficiency(RepairContext.Type.QUICK);
        }
        return ((Double)Config.Common.missingRepairKitEfficiency.get()).floatValue();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        RepairKitItem item;
        int value;
        Item item2;
        StackList list = StackList.from((CraftingInput)inv);
        ItemStack gear = list.uniqueOfType(GearItem.class).copy();
        ItemStack repairKit = list.uniqueOfType(RepairKitItem.class);
        Collection mats = list.allMatches(mat -> SgRecipes.isRepairMaterial(gear, mat));
        QuickRepairRecipe.repairWithLooseMaterials(gear, repairKit, mats);
        if (gear.getDamageValue() > 0 && (item2 = repairKit.getItem()) instanceof RepairKitItem && (value = (item = (RepairKitItem)item2).getDamageToRepair(gear, repairKit, RepairContext.Type.QUICK)) > 0) {
            gear.setDamageValue(gear.getDamageValue() - value);
        }
        GearData.incrementRepairedCount(gear, 1);
        GearData.recalculateGearData(gear, CommonHooks.getCraftingPlayer());
        return gear;
    }

    private static void repairWithLooseMaterials(ItemStack gear, ItemStack repairKit, Collection<ItemStack> mats) {
        float repairValue = QuickRepairRecipe.getRepairValueFromMaterials(gear, mats);
        float kitEfficiency = QuickRepairRecipe.getKitEfficiency(repairKit);
        float gearRepairEfficiency = GearData.getProperties(gear).getNumber(GearProperties.REPAIR_EFFICIENCY);
        gear.setDamageValue(gear.getDamageValue() - Math.round(repairValue * kitEfficiency * gearRepairEfficiency));
    }

    private static float getRepairValueFromMaterials(ItemStack gear, Collection<ItemStack> mats) {
        float repairEfficiency;
        float repairValue = 0.0f;
        for (ItemStack stack : mats) {
            MaterialInstance material = MaterialInstance.from(stack);
            if (material == null) continue;
            repairValue += (float)material.getRepairValue(gear);
        }
        if (gear.getItem() instanceof GearItem && (repairEfficiency = GearData.getProperties(gear).getNumber(GearProperties.REPAIR_EFFICIENCY)) > 0.0f) {
            repairValue *= repairEfficiency;
        }
        return repairValue;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList list = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        StackList stackList = StackList.from((CraftingInput)inv);
        ItemStack gear = stackList.uniqueMatch(s -> s.getItem() instanceof GearItem);
        ItemStack repairKit = stackList.uniqueMatch(s -> s.getItem() instanceof RepairKitItem);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item instanceof RepairKitItem) {
                RepairKitItem item2 = (RepairKitItem)item;
                QuickRepairRecipe.repairWithLooseMaterials(gear, repairKit, stackList.allMatches(mat -> SgRecipes.isRepairMaterial(gear, mat)));
                ItemStack copy = stack.copy();
                item2.removeRepairMaterials(copy, item2.getRepairMaterials(gear, copy, RepairContext.Type.QUICK));
                list.set(i, (Object)copy);
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            list.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return list;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SgRecipes.QUICK_REPAIR.get();
    }
}

