/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforgespi.language.IModInfo;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.gear.trait.condition.AndTraitCondition;
import net.silentchaos512.gear.network.payload.server.CommandOutputPayload;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;

public final class TraitsCommand {
    private static final SuggestionProvider<CommandSourceStack> TRAIT_ID_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.suggestResource(SgRegistries.TRAIT.stream().map(SgRegistries.TRAIT::getKey), (SuggestionsBuilder)builder);
    private static final String TRAITS_DATA_PATH = "https://github.com/SilentChaos512/Silent-Gear/tree/1.21.x/src/generated/resources/data/silentgear/silentgear_traits/";

    private TraitsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgear_traits").then(Commands.literal((String)"describe").then(Commands.argument((String)"traitID", (ArgumentType)ResourceLocationArgument.id()).suggests(TRAIT_ID_SUGGESTIONS).executes(context -> TraitsCommand.runDescribe((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getId((CommandContext)context, (String)"traitID")))))).then(Commands.literal((String)"dump_md").executes(TraitsCommand::runDumpMd))).then(Commands.literal((String)"list").executes(TraitsCommand::runList)));
    }

    private static int runDescribe(CommandContext<CommandSourceStack> context, ResourceLocation traitId) {
        Trait trait = (Trait)SgRegistries.TRAIT.get(traitId);
        if (trait == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.silentgear.traits.traitNotFound"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> trait.getDisplayName(0), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> trait.getDescription(1), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.silentgear.traits.maxLevel", (Object[])new Object[]{trait.getMaxLevel()}), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Object: " + String.valueOf(trait))), true);
        if (!trait.getEffects().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Effects:"), true);
        }
        for (TraitEffect effect : trait.getEffects()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("- " + String.valueOf(SgRegistries.TRAIT_EFFECT_TYPE.getKey(effect.type())))), true);
        }
        return 1;
    }

    private static int runList(CommandContext<CommandSourceStack> context) {
        String listStr = SgRegistries.TRAIT.stream().map(trait -> SgRegistries.TRAIT.getKey(trait).toString()).collect(Collectors.joining(", "));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)listStr), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Total: " + SgRegistries.TRAIT.keySet().size())), true);
        return 1;
    }

    private static int runDumpMd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        SilentGear.LOGGER.info("Send traits wiki dump packet to client {}", (Object)player.getScoreboardName());
        CommandOutputPayload message = CommandOutputPayload.traits();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDumpMdClient() {
        Player player = SilentGear.PROXY.getClientPlayer();
        if (player == null) {
            SilentGear.LOGGER.error("TraitsCommand#runDumpMcClient: player is null?");
            return;
        }
        String dirPath = "output/silentgear";
        String fileName = "traits_list.md";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            player.sendSystemMessage((Component)Component.literal((String)("Could not create directory: " + output.getParent())));
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            writer.write("# Traits\n\n");
            writer.write("Generated in-game by `sgear_traits dump_md` command on " + TraitsCommand.getCurrentDateTime() + "\n\n");
            writer.write("This data may or may not be accurate depending on the mod pack you are playing and the mods or data packs installed.\n\n");
            writer.write("## Data Sources\n\n");
            writer.write("The following mods and data packs have added traits to the output. Running the dump command yourself may produce different results.\n\n");
            writer.write(TraitsCommand.getDataSources() + "\n");
            writer.write("## Trait Effects\n\n");
            writer.write("This part of the command was not coded! Please bug SilentChaos512 to fix it. :)\n");
            writer.write("\n## List of Traits");
            ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(SgRegistries.TRAIT.keySet());
            ids.sort(Comparator.comparing(id -> Objects.requireNonNull((Trait)SgRegistries.TRAIT.get((ResourceLocation)id)).getDisplayName(0).getString()));
            for (ResourceLocation id2 : ids) {
                Trait trait = (Trait)SgRegistries.TRAIT.get(id2);
                assert (trait != null);
                writer.write("\n");
                writer.write("### " + TraitsCommand.getLinkToBuiltinTraitJson(id2, trait.getDisplayName(0).getString()) + "\n");
                writer.write("- " + trait.getDescription(0).getString() + "\n");
                String materialsWithTrait = TraitsCommand.getMaterialsWithTrait(trait);
                writer.write("- Found On:\n  - Materials: " + (materialsWithTrait.isEmpty() ? "Nothing" : materialsWithTrait) + "\n");
                String partsWithTrait = TraitsCommand.getPartsWithTrait(trait);
                if (!partsWithTrait.isEmpty()) {
                    writer.write("  - Parts: " + partsWithTrait + "\n");
                }
                if (!trait.getConditions().isEmpty()) {
                    AndTraitCondition condition = new AndTraitCondition(trait.getConditions().toArray(new ITraitCondition[0]));
                    writer.write("- Conditions: " + condition.getDisplayText().getString() + "\n");
                }
                writer.write("- ID: `" + String.valueOf(id2) + "`\n");
                writer.write("- Max Level: " + trait.getMaxLevel() + "\n");
                if (!trait.getEffects().isEmpty()) {
                    writer.write("- Effects:\n");
                }
                for (TraitEffect effect : trait.getEffects()) {
                    writer.write("  - `" + String.valueOf(SgRegistries.TRAIT_EFFECT_TYPE.getKey(effect.type())) + "`");
                }
                Collection<String> wikiLines = trait.getExtraWikiLines();
                if (wikiLines.isEmpty()) continue;
                writer.write("- Extra Info:\n");
                for (String line : wikiLines) {
                    writer.write(line + "\n");
                }
            }
            writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            MutableComponent fileNameText = Component.literal((String)output.getAbsolutePath()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, output.getAbsolutePath())));
            player.sendSystemMessage((Component)Component.literal((String)"Wrote to ").append((Component)fileNameText));
        }
    }

    private static String getCurrentDateTime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        return formatter.format(now);
    }

    private static String getLinkToBuiltinTraitJson(ResourceLocation traitId, String text) {
        if ("silentgear".equals(traitId.getNamespace())) {
            return String.format("[%s](%s)", text, TRAITS_DATA_PATH + traitId.getPath() + ".json");
        }
        return text;
    }

    private static String getMaterialsWithTrait(Trait trait) {
        StringBuilder str = new StringBuilder();
        boolean foundAny = false;
        for (Material material : SgRegistries.MATERIAL.getValues(false)) {
            MaterialInstance instance = MaterialInstance.of(material);
            ArrayList<PartType> typesWithTrait = new ArrayList<PartType>();
            block1: for (PartType partType : SgRegistries.PART_TYPE) {
                Collection<TraitInstance> traits = instance.getTraits(PartGearKey.of((GearType)GearTypes.ALL.get(), partType));
                for (TraitInstance inst : traits) {
                    if (!inst.getTrait().equals(trait)) continue;
                    typesWithTrait.add(partType);
                    continue block1;
                }
            }
            if (typesWithTrait.isEmpty()) continue;
            if (foundAny) {
                str.append(", ");
            }
            foundAny = true;
            str.append("**").append(instance.getDisplayName((PartType)PartTypes.MAIN.get()).getString()).append("**").append(" _(").append(typesWithTrait.stream().map(pt -> pt.getDisplayName().getString()).collect(Collectors.joining(", "))).append(")_");
        }
        return str.toString();
    }

    private static String getPartsWithTrait(Trait trait) {
        StringBuilder str = new StringBuilder();
        boolean foundAny = false;
        for (GearPart part : SgRegistries.PART) {
            PartInstance partData = PartInstance.of(part);
            for (TraitInstance inst : partData.getTraits(PartGearKey.of(GearTypes.ALL, PartTypes.MAIN))) {
                if (!inst.getTrait().equals(trait) || !part.isVisible()) continue;
                if (foundAny) {
                    str.append(", ");
                }
                foundAny = true;
                str.append("**").append(partData.getDisplayName(partData.getType()).getString()).append("**");
            }
        }
        return str.toString();
    }

    private static String getDataSources() {
        LinkedHashSet<String> sourceSet = new LinkedHashSet<String>();
        for (Trait trait : SgRegistries.TRAIT) {
            sourceSet.add(SgRegistries.TRAIT.getKey(trait).getNamespace());
        }
        StringBuilder ret = new StringBuilder();
        for (String id : sourceSet) {
            ret.append("- ");
            Optional container = ModList.get().getModContainerById(id);
            if (container.isPresent()) {
                IModInfo modInfo = ((ModContainer)container.get()).getModInfo();
                ret.append(modInfo.getDisplayName()).append(" (").append(id).append(") ").append(modInfo.getVersion()).append("\n");
                continue;
            }
            ret.append(id);
        }
        return ret.toString();
    }
}

