/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.entity.projectile.GearArrowEntity;

public class GearArrowRenderer
extends EntityRenderer<GearArrowEntity> {
    public static final ResourceLocation GEAR_ARROW_LOCATION = SilentGear.getId("textures/entity/arrow.png");

    public GearArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(GearArrowEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        float f9 = (float)entity.shakeTime - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -Mth.sin((float)(f9 * 3.0f)) * f9;
            poseStack.mulPose(Axis.ZP.rotationDegrees(f10));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(0.05625f, 0.05625f, 0.05625f);
        poseStack.translate(-4.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)GEAR_ARROW_LOCATION));
        PoseStack.Pose posestack$pose = poseStack.last();
        int rodColor = entity.getRodColor();
        int tipColor = entity.getTipColor();
        int fletchingColor = entity.getFletchingColor();
        this.vertex(posestack$pose, vertexconsumer, -7.0f, -2.0f, -2.0f, 0.0f, 0.15625f, -1, 0, 0, packedLight, fletchingColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, -2.0f, 2.0f, 0.15625f, 0.15625f, -1, 0, 0, packedLight, fletchingColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, 2.0f, 2.0f, 0.15625f, 0.3125f, -1, 0, 0, packedLight, fletchingColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, 2.0f, -2.0f, 0.0f, 0.3125f, -1, 0, 0, packedLight, fletchingColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, 2.0f, -2.0f, 0.0f, 0.15625f, 1, 0, 0, packedLight, fletchingColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, 2.0f, 2.0f, 0.15625f, 0.15625f, 1, 0, 0, packedLight, fletchingColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, -2.0f, 2.0f, 0.15625f, 0.3125f, 1, 0, 0, packedLight, fletchingColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, -2.0f, -2.0f, 0.0f, 0.3125f, 1, 0, 0, packedLight, fletchingColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, -0.4f, -0.4f, 0.15625f, 0.15625f, -1, 0, 0, packedLight, rodColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, -0.4f, 0.4f, 0.1875f, 0.15625f, -1, 0, 0, packedLight, rodColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, 0.4f, 0.4f, 0.1875f, 0.1875f, -1, 0, 0, packedLight, rodColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, 0.4f, -0.4f, 0.15625f, 0.1875f, -1, 0, 0, packedLight, rodColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, 0.4f, -0.4f, 0.0f, 0.15625f, 1, 0, 0, packedLight, rodColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, 0.4f, 0.4f, 0.15625f, 0.15625f, 1, 0, 0, packedLight, rodColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, -0.4f, 0.4f, 0.15625f, 0.3125f, 1, 0, 0, packedLight, rodColor);
        this.vertex(posestack$pose, vertexconsumer, -7.0f, -0.4f, -0.4f, 0.0f, 0.3125f, 1, 0, 0, packedLight, rodColor);
        for (int j = 0; j < 4; ++j) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.vertex(posestack$pose, vertexconsumer, -8.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0, 1, 0, packedLight, rodColor);
            this.vertex(posestack$pose, vertexconsumer, 5.0f, -2.0f, 0.0f, 0.40625f, 0.0f, 0, 1, 0, packedLight, rodColor);
            this.vertex(posestack$pose, vertexconsumer, 5.0f, 2.0f, 0.0f, 0.40625f, 0.15625f, 0, 1, 0, packedLight, rodColor);
            this.vertex(posestack$pose, vertexconsumer, -8.0f, 2.0f, 0.0f, 0.0f, 0.15625f, 0, 1, 0, packedLight, rodColor);
            this.vertex(posestack$pose, vertexconsumer, 5.0f, -2.0f, 0.0f, 0.40625f, 0.0f, 0, 1, 0, packedLight, tipColor);
            this.vertex(posestack$pose, vertexconsumer, 8.0f, -2.0f, 0.0f, 0.5f, 0.0f, 0, 1, 0, packedLight, tipColor);
            this.vertex(posestack$pose, vertexconsumer, 8.0f, 2.0f, 0.0f, 0.5f, 0.15625f, 0, 1, 0, packedLight, tipColor);
            this.vertex(posestack$pose, vertexconsumer, 5.0f, 2.0f, 0.0f, 0.40625f, 0.15625f, 0, 1, 0, packedLight, tipColor);
            this.vertex(posestack$pose, vertexconsumer, -8.0f, -2.0f, 0.0f, 0.5f, 0.0f, 0, 1, 0, packedLight, fletchingColor);
            this.vertex(posestack$pose, vertexconsumer, -4.0f, -2.0f, 0.0f, 0.625f, 0.0f, 0, 1, 0, packedLight, fletchingColor);
            this.vertex(posestack$pose, vertexconsumer, -4.0f, 2.0f, 0.0f, 0.625f, 0.15625f, 0, 1, 0, packedLight, fletchingColor);
            this.vertex(posestack$pose, vertexconsumer, -8.0f, 2.0f, 0.0f, 0.5f, 0.15625f, 0, 1, 0, packedLight, fletchingColor);
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer consumer, float x, float y, float z, float u, float v, int normalX, int normalY, int normalZ, int packedLight, int color) {
        consumer.addVertex(pose, x, y, z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)normalX, (float)normalZ, (float)normalY);
    }

    public ResourceLocation getTextureLocation(GearArrowEntity entity) {
        return GEAR_ARROW_LOCATION;
    }
}

